/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.support.annotation.NonNull;
import com.beaconsinspace.android.beacon.detector.BISLog;
import com.beaconsinspace.android.beacon.detector.BISNetworkingThread;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

class BISNetworkingCrashThread
extends BISNetworkingThread<String> {
    @NonNull
    private final String sentryUrl;
    @NonNull
    private final String sentryKey;
    @NonNull
    private final String sentrySecret;
    @NonNull
    private final Throwable throwable;

    public BISNetworkingCrashThread(@NonNull String sentryUrl, @NonNull String sentryKey, @NonNull String sentrySecret, Throwable throwable) {
        this.sentryUrl = sentryUrl;
        this.sentryKey = sentryKey;
        this.sentrySecret = sentrySecret;
        this.throwable = throwable;
    }

    @Override
    public void run() {
        block4: {
            try {
                String line;
                TimeZone tz = TimeZone.getTimeZone("UTC");
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                df.setTimeZone(tz);
                Date d = new Date();
                String timestamp = df.format(d);
                long seconds = d.getTime() / 1000L;
                HttpURLConnection urlConnection = (HttpURLConnection)new URL(this.sentryUrl).openConnection();
                urlConnection.setDoOutput(true);
                urlConnection.setRequestProperty("content-type", "application/json");
                urlConnection.setRequestProperty("x-sentry-auth", "Sentry sentry_version=7,sentry_client=com.beaconsinspace.detector/2.1.3,sentry_timestamp=" + seconds + ",sentry_key=" + this.sentryKey + ",sentry_secret=" + this.sentrySecret);
                urlConnection.setRequestMethod("POST");
                urlConnection.connect();
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                this.throwable.printStackTrace(pw);
                String stackTrace = sw.toString().replace("\n", " ").replace("\t", "");
                String data = "{\"culprit\": \"com.beaconsinspace.detector\", \"platform\" : \"java\", \"timestamp\" : \"" + timestamp + "\", \"message\":\"" + this.throwable.getMessage() + "\", \"exception\" : [{\"type\" : \"" + this.throwable.getClass().getName() + "\", \"value\":\"" + stackTrace + "\"}]}";
                OutputStream outputStream = urlConnection.getOutputStream();
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
                writer.write(data);
                writer.close();
                outputStream.close();
                BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "UTF-8"));
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                reader.close();
                if (this.listener != null) {
                    this.listener.onSuccess(sb.toString());
                }
            }
            catch (Throwable t) {
                BISLog.e("BISNetworkingCrashThread", "Failed to report crash");
                if (this.listener == null) break block4;
                this.listener.onError(t);
            }
        }
    }
}

