package com.beaconsinspace.android.beacon.detector;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.app.job.JobService;
import android.util.Log;

import java.util.Timer;
import java.util.TimerTask;

/**
 * Created by kyleshank on 10/12/17.
 */

@TargetApi(26)
public class BISJobService extends JobService {
    private Timer timer;
    private TimerTask timerTask;

    private static final String TAG = "BISJobService";

    @Override
    public boolean onStartJob(final JobParameters jobParameters) {
        try {
            final BISDetector detector = new BISDetector(getApplicationContext());
            detector.contextDescription = "BISJobService";
            detector.bootstrap(new BISDetectorBootstrapListener() {
                @Override
                public void onBootstrapSuccess(BISDetector detector) {
                    final BISCollectionManager collectionManager = detector.getCollectionManager();
                    if (collectionManager != null) {
                        collectionManager.startLocationGathering();
                    }
                }

                @Override
                public void onBootstrapFailure() {
                    Log.d(TAG, "Bootstrap failed.");
                }
            });
            return false;
        } catch (Throwable t) {
            BISLog.e(TAG,t.getMessage());
        }

        return false;
    }

    @Override
    public boolean onStopJob(JobParameters jobParameters) {
        return false;
    }
}
