package com.beaconsinspace.android.beacon.detector.deviceatlas;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Rect;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.os.Build;
import android.util.Log;

import java.util.ArrayList;
import java.util.List;


/**
 * @author Afilias Technologies Ltd
 */
@TargetApi(Build.VERSION_CODES.LOLLIPOP)
class CameraV2 {
    private static final String TAG = CameraV2.class.getName();


    public static List<Camera> getCameras(Context context)  {
        List<Camera> toReturn = new ArrayList<>();

        CameraManager manager = (CameraManager)context.getSystemService(Context.CAMERA_SERVICE);
        try {

            String[] cameras = manager.getCameraIdList();
            for(String cameraId : cameras) {
                CameraCharacteristics chara = manager.getCameraCharacteristics(cameraId);
                boolean hasFlash = chara.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);

                Rect pixelRect =  chara.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);

                toReturn.add(new Camera(pixelRect.width(), pixelRect.height(), getFacing(chara), hasFlash));
            }

        } catch (CameraAccessException | SecurityException e ) {
        }

        return toReturn;
    }


    private static String getFacing(CameraCharacteristics chara) {
        Integer facing = chara.get(CameraCharacteristics.LENS_FACING);

        switch(facing) {
            case CameraCharacteristics.LENS_FACING_FRONT:
                return CameraProperties.FACING_FRONT;
            case CameraCharacteristics.LENS_FACING_BACK:
                return CameraProperties.FACING_BACK;
            case CameraCharacteristics.LENS_FACING_EXTERNAL:
                return CameraProperties.FACING_EXTERNAL;
            default:
                return "id="+facing;
        }
    }

}
