package com.beaconsinspace.android.beacon.detector.deviceatlas;

import android.annotation.TargetApi;
import android.hardware.Camera.Size;
import android.os.Build;
import android.util.Log;

import java.util.ArrayList;
import java.util.List;


/**
 * @author Afilias Technologies Ltd
 */
@SuppressWarnings("deprecation")
@TargetApi(Build.VERSION_CODES.GINGERBREAD)
class CameraV1 {
    private static final String TAG = CameraV1.class.getName();


    public static List<Camera> getCameras()  {
        List<Camera> toReturn = new ArrayList<>();

        int numCams = android.hardware.Camera.getNumberOfCameras();
        for(int id=0; id<numCams; id++) {
            android.hardware.Camera camera = null;
            try {

                camera = android.hardware.Camera.open(id);
                android.hardware.Camera.Parameters params = camera.getParameters();

                List<Size> sizes = params.getSupportedPictureSizes();
                Size maxSize = null;
                for(int i=0; i<sizes.size(); i++) {
                    Size s = sizes.get(i);
                    if(maxSize == null || s.width > maxSize.width) {
                        maxSize = s;
                    }
                }
                if(maxSize != null) {
                    toReturn.add(new Camera(maxSize.width, maxSize.height, getFacing(id), hasFlash(params)));
                }
            } catch(RuntimeException ex) {
                // this can happen if the camera is open in another application
            } finally {
                if(camera != null) {
                    camera.release();
                }
            }
        }

        return toReturn;
    }


    public static boolean hasFlash(android.hardware.Camera.Parameters params) {
        List<String> supportedFlashModes = params.getSupportedFlashModes();
        if (supportedFlashModes == null
                || supportedFlashModes.isEmpty()
                || supportedFlashModes.size() == 1 && supportedFlashModes.get(0).equals(android.hardware.Camera.Parameters.FLASH_MODE_OFF)) {
            return false;
        }

        return true;
    }


    private static String getFacing(int cameraId) {
        android.hardware.Camera.CameraInfo info = new android.hardware.Camera.CameraInfo();
        android.hardware.Camera.getCameraInfo(cameraId, info);

        String facing;
        switch(info.facing) {
            case android.hardware.Camera.CameraInfo.CAMERA_FACING_FRONT:
                facing = CameraProperties.FACING_FRONT;
                break;
            case android.hardware.Camera.CameraInfo.CAMERA_FACING_BACK:
                facing = CameraProperties.FACING_BACK;
                break;
            default:
                facing = "id="+info.facing;
        }

        return facing;
    }

}
