/*
 * Copyright (c) Afilias Technologies Ltd 2017. All rights reserved.
 */

package com.beaconsinspace.android.beacon.detector.deviceatlas;

import java.math.BigDecimal;

/**
 * @author Afilias Technologies Ltd
 */
class Camera {
    final int widthPixels;
    final int heightPixels;
    final String megaPixels;
    final String facing;
    final boolean hasFlash;


    Camera(int widthPixels, int heightPixels, String facing, boolean hasFlash) {
        this.widthPixels = widthPixels;
        this.heightPixels = heightPixels;
        this.facing = facing;
        this.hasFlash = hasFlash;
        this.megaPixels = calculateMegaPixels(widthPixels, heightPixels);
    }


    public static String calculateMegaPixels(int width, int height) {
        // cant use DecimalFormat - rounding mode only added in API 9 and we are targeting API 7.
        BigDecimal mPix = new BigDecimal(width*height).divide(new BigDecimal(1024000));
        mPix = mPix.setScale(1, BigDecimal.ROUND_HALF_UP); // round to one decimal place

        return mPix.toPlainString();
    }
}
