package com.beaconsinspace.android.beacon.detector;

import android.app.Activity;

import com.beaconsinspace.android.beacon.detector.deviceatlas.DataCollector;
import com.beaconsinspace.android.beacon.detector.deviceatlas.HandleDataCallback;

/**
 * Created by Akshayraj on 2/9/17.
 */

public class BISDeviceAtlas extends Activity {

    private static final String TAG = "BISDeviceAtlas";

    @Override
    protected void onStart() {
        super.onStart();
        try
        {
            DataCollector collector = new DataCollector(this, new HandleDataCallback() {

                @Override
                public void handleData(String deviceMetaData) {
                    if(deviceMetaData != null) {
                        BISPersistentStorage persistentStorage = new BISPersistentStorage(getApplicationContext());
                        persistentStorage.storeDeviceMetaData(deviceMetaData);
                        persistentStorage.setDeviceMetaDataCollected(true);
                    }
                    //finish the Activity
                    finish();
                }
            });
        } catch (Throwable t){
            BISLog.e(TAG,t.getMessage());
        }
    }
}
