package com.beaconsinspace.android.beacon.detector;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by johnlfoleyiii on 8/10/16.
 */
class BISDetectorRSSICollector
{

    private static final String TAG="BIS_RSSI_COLLECTOR";
    private final Integer RSSI_DIFFERENCE=4;
    private Integer mostRecentlyStoredRSSI;

    protected ConcurrentHashMap<Integer, String> values = new ConcurrentHashMap<>();

    public void add( Integer rssi )
    {
        // determine if the value is different enough to be stored
        boolean isSignificantlyDifferent=false;
        if ( mostRecentlyStoredRSSI == null || Math.abs( mostRecentlyStoredRSSI - rssi ) >= RSSI_DIFFERENCE )
        {
            isSignificantlyDifferent=true;
        }
        if ( isSignificantlyDifferent )
        {
            String timestamp = BigDecimal.valueOf(System.currentTimeMillis() / 1000.0).toString();

            values.put( rssi, timestamp );
            mostRecentlyStoredRSSI=rssi;
        }
    }

    public String toJson()
    {
        JSONArray jsonArray = new JSONArray();
        for ( Integer rssi : values.keySet() )
        {
            String timestamp = values.get(rssi);
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put( "r", rssi );
                jsonObject.put( "t", timestamp );
                jsonArray.put( jsonObject );
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return jsonArray.toString();
    }

}
