/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.app.IntentService;
import android.content.Intent;
import android.util.Log;
import com.beaconsinspace.android.beacon.detector.BISCollectionEvent;
import com.beaconsinspace.android.beacon.detector.BISCollectionManager;
import com.beaconsinspace.android.beacon.detector.BISDetector;
import com.beaconsinspace.android.beacon.detector.BISDetectorBootstrapListener;
import com.beaconsinspace.android.beacon.detector.BISLog;
import com.google.android.gms.location.GeofencingEvent;

public class BISGeofenceTransitionsIntentService
extends IntentService {
    public static final String INTENT = "BISGeofenceTransitionsIntentService";
    private static final String TAG = "GeofenceTransitionsIS";

    public BISGeofenceTransitionsIntentService() {
        super(TAG);
    }

    protected void onHandleIntent(Intent intent) {
        block3: {
            BISDetector detector = null;
            try {
                final GeofencingEvent geofencingEvent = GeofencingEvent.fromIntent((Intent)intent);
                if (geofencingEvent.hasError()) {
                    String errorMessage = "Geofence error: " + geofencingEvent.getErrorCode();
                    Log.e((String)TAG, (String)errorMessage);
                    return;
                }
                detector = new BISDetector(this.getApplicationContext());
                detector.contextDescription = "GeoFence";
                detector.bootstrap(new BISDetectorBootstrapListener(){

                    @Override
                    public void onBootstrapSuccess(BISDetector detector) {
                        BISCollectionManager collectionManager = detector.getCollectionManager();
                        if (collectionManager != null) {
                            BISCollectionEvent.BISCollectionEventDirection direction = BISCollectionEvent.BISCollectionEventDirection.None;
                            switch (geofencingEvent.getGeofenceTransition()) {
                                case 1: {
                                    BISLog.d(BISGeofenceTransitionsIntentService.TAG, "GEOFENCE_TRANSITION_ENTER");
                                    direction = BISCollectionEvent.BISCollectionEventDirection.Enter;
                                    break;
                                }
                                case 2: {
                                    BISLog.d(BISGeofenceTransitionsIntentService.TAG, "GEOFENCE_TRANSITION_EXIT");
                                    direction = BISCollectionEvent.BISCollectionEventDirection.Exit;
                                    break;
                                }
                                case 4: {
                                    BISLog.d(BISGeofenceTransitionsIntentService.TAG, "GEOFENCE_TRANSITION_DWELL");
                                    direction = BISCollectionEvent.BISCollectionEventDirection.Dwell;
                                    break;
                                }
                            }
                            BISCollectionEvent event = new BISCollectionEvent(detector.getContext(), BISCollectionEvent.BISCollectionEventType.GeoFence, detector.applicationState, direction, geofencingEvent.getTriggeringLocation());
                            collectionManager.triggerEvent(event);
                        }
                    }

                    @Override
                    public void onBootstrapFailure() {
                        Log.d((String)BISGeofenceTransitionsIntentService.TAG, (String)"Bootstrap failed.");
                    }
                });
            }
            catch (Throwable t) {
                if (detector == null) break block3;
                detector.reportCrash(t);
            }
        }
    }
}

