/*
 * Copyright (c) Afilias Technologies Ltd 2017. All rights reserved.
 */


package com.beaconsinspace.android.beacon.detector.deviceatlas;

import android.content.Context;
import android.os.Build;
import android.telephony.TelephonyManager;

import org.json.JSONException;
import org.json.JSONObject;


/**
 * @author Afilias Technologies Ltd
 */
class TelephonyProperties {

    private static final String MMS_UA_PROF_URL = "mmsUaProfUrl";
    private static final String MMS_UA = "mmsUa";
    private static final String PHONE_TYPE = "phoneType";
    private static final String NETWORK_MCC_MNC = "networkMccMnc";
    private static final String NETWORK_OPERATOR = "networkOperator";
    private static final String NETWORK_COUNTRY_ISO = "networkCountryIso";
    private static final String SIM_MCC_MNC = "simMccMnc";
    private static final String SIM_OPERATOR = "simOperator";
    private static final String SIM_COUNTRY_ISO = "simCountryIso";
    private static final String PHONE_COUNT = "phoneCount";
    private static final String IS_ROAMING = "isRoaming";
    private static final String IS_VOICE_CAPABLE = "isVoiceCapable";
    private static final String IS_WORLD_PHONE = "isWorldPhone";
    private static final String IS_HEARING_AID_COMPATIBLE = "isHearingAidCompatibilitySupported";
    private static final String IS_TTY_MODE_SUPPORTED = "isTtyModeSupported";
    private static final String TAC = "tac";



    public static JSONObject getProperties(Context context) throws JSONException {
        TelephonyManager tm = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
        JSONObject props = new JSONObject();

        props.put(IS_ROAMING, tm.isNetworkRoaming());
        props.put(PHONE_TYPE, getPhoneType(tm));
        props.put(NETWORK_MCC_MNC, tm.getNetworkOperator());
        props.put(NETWORK_OPERATOR, tm.getNetworkOperatorName());
        props.put(NETWORK_COUNTRY_ISO, tm.getNetworkCountryIso());

        if(tm.getSimState() == TelephonyManager.SIM_STATE_READY) {
            props.put(SIM_MCC_MNC, tm.getSimOperator());
            props.put(SIM_OPERATOR, tm.getSimOperatorName());
            props.put(SIM_COUNTRY_ISO, tm.getSimCountryIso());
        }

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            try {
                props.put(MMS_UA_PROF_URL, tm.getMmsUAProfUrl());
                props.put(MMS_UA, tm.getMmsUserAgent());
            } catch(SecurityException ex) {/* it seems some of these can throw an unreported exception :/... */}
        }

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP_MR1) {
            props.put(IS_VOICE_CAPABLE, tm.isVoiceCapable());
        }

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            try {
                props.put(PHONE_COUNT, tm.getPhoneCount());
                props.put(IS_HEARING_AID_COMPATIBLE, tm.isHearingAidCompatibilitySupported());
                props.put(IS_TTY_MODE_SUPPORTED, tm.isTtyModeSupported());
            } catch(SecurityException ex) {/* it seems some of these can throw an unreported exception :/... */}

        }

        // NOTE: this requires the READ_PHONE_STATE permission, we may not always want to require this.
        props.put(TAC, getTac(tm));

        return props;
    }



    private static String getPhoneType(TelephonyManager tm) {
        int type = tm.getPhoneType();
        switch(type) {
            case TelephonyManager.PHONE_TYPE_GSM:
                return "gsm";
            case TelephonyManager.PHONE_TYPE_CDMA:
                return "cdma";
            case TelephonyManager.PHONE_TYPE_SIP:
                return "sip";
            case TelephonyManager.PHONE_TYPE_NONE:
                return "none";
            default:
                return "id="+type;
        }
    }


    private static String getTac(TelephonyManager tm) {
        String tac = "";

        if(tm.getPhoneType() == TelephonyManager.PHONE_TYPE_GSM) {
            try {
                String deviceId = tm.getDeviceId();
                if (deviceId != null && deviceId.length() > 8) {
                    tac = deviceId.substring(0, 8);
                }
            } catch(SecurityException ex) {/* we may not have readphone state... */}
        }

        return tac;
    }

}
