/*
 * Copyright (c) Afilias Technologies Ltd 2017. All rights reserved.
 */


package com.beaconsinspace.android.beacon.detector.deviceatlas;

import java.util.Arrays;

/**
 * @author Afilias Technologies Ltd
 */
class StrUtil {

    public static String asString(Object object) {
        if(object == null) {
            return "null";
        }

        if(isArray(object)) {
            return Arrays.deepToString((Object[])object);
        } else {
            return object.toString();
        }

    }


    public static boolean isArray(Object obj) {
        return obj!=null && obj.getClass().isArray();
    }

    public static String toCamelCase(String str) {
        StringBuilder sb = new StringBuilder();

        boolean first = true;
        for(String part : str.split("[_\\- ]")) {
            if(part.equals("")) {
                continue;
            }

            if(first) {
                sb.append(part.toLowerCase());
                first = false;
            } else {
                sb.append(part.substring(0, 1).toUpperCase());
                sb.append(part.substring(1).toLowerCase());
            }
        }

        return sb.toString();
    }

}
