package com.beaconsinspace.android.beacon.detector;

import android.os.AsyncTask;
import android.util.Log;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * Created by kyleshank on 9/28/17.
 */

class BISNetworkingGetThread extends BISNetworkingThread<String> {

    static private final String TAG = "BIS_NETWORK_REQUEST";
    static public final int STATUS_SUCCESS = 200;
    private final BISDetector detector;
    private final String uri;

    public BISNetworkingGetThread(BISDetector detector, String uri){
        this.detector = detector;
        this.uri = uri;
    }

    // reads an InputStream and converts it to a String
    private String readStream(InputStream stream) throws Exception {

        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        StringBuilder fullString = new StringBuilder();
        String line;

        while ((line = reader.readLine()) != null) {
            fullString.append(line);
        }

        return fullString.toString();
    }

    @Override
    public void run(){
        InputStream inputStream = null;

        try
        {
            // prepare auth header
            String authorizationHeader = BISNetworking.getAuthorizationHeader(detector);
            URL url = new URL(uri);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setRequestProperty( "Authorization", authorizationHeader );
            connection.setConnectTimeout(30000);
            connection.connect();

            int response = connection.getResponseCode();

            if(response == STATUS_SUCCESS)
            {
                inputStream = new BufferedInputStream(connection.getInputStream());
                String result = readStream(inputStream);
                if(this.listener != null){
                    this.listener.onSuccess(result);
                }
            }
            else
            {
                if(this.listener != null){
                    this.listener.onError(new BISException("Not found"));
                }
                Log.i(TAG, "STATUS_CODE is " + response);
            }
        }catch(Throwable t){
            if(this.listener != null){
                this.listener.onError(t);
            }
        }
        finally
        {
            try
            {
                if(inputStream != null)
                {
                    inputStream.close();
                }
            }catch(Throwable t){
                detector.reportCrash(t);
            }
        }
    }
}