/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.app.Activity;
import android.app.Application;
import android.app.Service;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.util.Log;
import com.beaconsinspace.android.beacon.detector.BISCollectionManager;
import com.beaconsinspace.android.beacon.detector.BISConfiguration;
import com.beaconsinspace.android.beacon.detector.BISConfigurationInitializationListener;
import com.beaconsinspace.android.beacon.detector.BISDetectorBootstrapListener;
import com.beaconsinspace.android.beacon.detector.BISDeviceAtlas;
import com.beaconsinspace.android.beacon.detector.BISDeviceUUID;
import com.beaconsinspace.android.beacon.detector.BISJobService;
import com.beaconsinspace.android.beacon.detector.BISLog;
import com.beaconsinspace.android.beacon.detector.BISLogDelegate;
import com.beaconsinspace.android.beacon.detector.BISNetworkingCrashThread;
import com.beaconsinspace.android.beacon.detector.BISPersistentStorage;
import java.util.UUID;

public class BISDetector
extends Service
implements Application.ActivityLifecycleCallbacks {
    public static final String SDK_VERSION = "2.1.0";
    private static final String TAG = "BIS_API";
    private String apiKey = "";
    private String adid = "";
    private UUID uuid;
    static BISLogDelegate logDelegate;
    private static BISDetector configuredDetector;
    private BISCollectionManager collectionManager;
    private BISConfiguration configuration;
    private Thread primaryProcessThread;
    private Context context;
    private BISPersistentStorage persistentStorage;
    public String contextDescription = "";
    public ApplicationState applicationState = ApplicationState.BACKGROUND;

    public BISDetector() {
    }

    public BISDetector(@NonNull Context context) {
        this.context = context;
        if (context != null) {
            this.persistentStorage = new BISPersistentStorage(context);
            this.apiKey = this.persistentStorage.getString("BIS_API_KEY");
            this.setupCallbacks();
        }
    }

    public BISDetector(@NonNull Context context, @NonNull String apiKey) {
        this.context = context;
        if (context != null) {
            this.persistentStorage = new BISPersistentStorage(context);
            this.apiKey = apiKey;
            this.persistentStorage.storeString("BIS_API_KEY", apiKey);
            this.setupCallbacks();
        }
    }

    private void setupCallbacks() {
        if (this.context instanceof Application) {
            Application application = (Application)this.context;
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
        this.applicationState = ApplicationState.INACTIVE;
    }

    public void onActivityStarted(Activity activity) {
        this.applicationState = ApplicationState.ACTIVE;
    }

    public void onActivityResumed(Activity activity) {
        this.applicationState = ApplicationState.ACTIVE;
    }

    public void onActivityPaused(Activity activity) {
        this.applicationState = ApplicationState.BACKGROUND;
    }

    public void onActivityStopped(Activity activity) {
        this.applicationState = ApplicationState.BACKGROUND;
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public static void configure(String key, Context ctx) {
        BISDetector.configure(key, ctx, null);
    }

    public static void configure(String key, Context ctx, BISLogDelegate logDelegate) {
        try {
            Log.d((String)TAG, (String)"Configuring BISDetector SDK 2.1.0");
            BISDetector.logDelegate = logDelegate;
            if (configuredDetector == null) {
                BISDetector detector = new BISDetector(ctx, key);
                detector.contextDescription = "App";
                if (Build.VERSION.SDK_INT >= 26) {
                    BISDetector.scheduleJob(detector);
                    detector.foregroundService();
                } else {
                    ctx.sendBroadcast(new Intent("BootstrapBeaconsInSpace"));
                }
                configuredDetector = detector;
            }
        }
        catch (Throwable e) {
            BISLog.e(TAG, "Error configuring: " + e.getMessage());
        }
    }

    private void foregroundService() {
        if (this.primaryProcessThread == null) {
            this.primaryProcessThread = new Thread(){

                @Override
                public void run() {
                    try {
                        BISDetector.this.bootstrap(new BISDetectorBootstrapListener(){

                            @Override
                            public void onBootstrapSuccess(BISDetector detector) {
                                BISLog.d(BISDetector.TAG, "Bootstrapped. (" + BISDetector.this.contextDescription + ")");
                            }

                            @Override
                            public void onBootstrapFailure() {
                                BISLog.d(BISDetector.TAG, "Bootstrap failed. (" + BISDetector.this.contextDescription + ")");
                            }
                        });
                    }
                    catch (Throwable t) {
                        BISDetector.this.reportCrash(t);
                    }
                }
            };
            this.primaryProcessThread.start();
        }
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.context = this.getApplicationContext();
        this.persistentStorage = new BISPersistentStorage(this.context);
        this.apiKey = this.persistentStorage.getString("BIS_API_KEY");
        this.contextDescription = "StickyService";
        if (this.primaryProcessThread == null) {
            this.primaryProcessThread = new Thread(){

                @Override
                public void run() {
                    try {
                        BISDetector.this.bootstrap(new BISDetectorBootstrapListener(){

                            @Override
                            public void onBootstrapSuccess(BISDetector detector) {
                                BISLog.d(BISDetector.TAG, "Bootstrapped. (" + BISDetector.this.contextDescription + ")");
                            }

                            @Override
                            public void onBootstrapFailure() {
                                BISLog.d(BISDetector.TAG, "Bootstrap failed. (" + BISDetector.this.contextDescription + ")");
                            }
                        }, true);
                    }
                    catch (Throwable t) {
                        BISDetector.this.reportCrash(t);
                    }
                }
            };
            this.primaryProcessThread.start();
        }
        return 1;
    }

    private static void scheduleJob(final BISDetector detector) {
        if (Build.VERSION.SDK_INT >= 26) {
            BISLog.d(TAG, "Scheduling job");
            BISConfiguration bISConfiguration = new BISConfiguration(detector, new BISConfigurationInitializationListener(){

                @Override
                public void onInitializationSuccess(BISConfiguration initializedConfiguration) {
                    if (Build.VERSION.SDK_INT >= 26) {
                        int jobId = 1337;
                        ComponentName mServiceComponent = new ComponentName(detector.getContext(), BISJobService.class);
                        JobInfo.Builder builder = new JobInfo.Builder(jobId, mServiceComponent);
                        builder.setPeriodic((long)initializedConfiguration.locationMonitoringInterval.intValue());
                        builder.setRequiredNetworkType(1);
                        JobScheduler tm = (JobScheduler)detector.getContext().getSystemService("jobscheduler");
                        tm.cancel(jobId);
                        tm.schedule(builder.build());
                    }
                }
            });
        }
    }

    public void bootstrap(BISDetectorBootstrapListener bootstrapListener) {
        this.bootstrap(bootstrapListener, false);
    }

    public void bootstrap(final BISDetectorBootstrapListener bootstrapListener, final boolean stickyService) {
        boolean hasCoarseLocation;
        if (bootstrapListener == null) {
            Log.d((String)TAG, (String)"Bootstrap listener required.");
            return;
        }
        if (this.context == null) {
            Log.d((String)TAG, (String)"Context must be set before bootstrap.");
            bootstrapListener.onBootstrapFailure();
            return;
        }
        if (this.persistentStorage == null) {
            Log.d((String)TAG, (String)"Persistent storage must be set before bootstrap.");
            bootstrapListener.onBootstrapFailure();
            return;
        }
        if (this.apiKey == null) {
            Log.d((String)TAG, (String)"API KEY must be set before bootstrap.");
            bootstrapListener.onBootstrapFailure();
            return;
        }
        boolean hasInternetPermission = ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.INTERNET") == 0;
        boolean hasFineLocation = ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
        boolean bl = hasCoarseLocation = ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_COARSE_LOCATION") == 0;
        if (!hasFineLocation && !hasCoarseLocation) {
            Log.d((String)TAG, (String)"ACCESS_FINE_LOCATION or ACCESS_COARSE_LOCATION permission required.");
        }
        if (!hasInternetPermission) {
            Log.d((String)TAG, (String)"INTERNET permission required.");
            bootstrapListener.onBootstrapFailure();
            return;
        }
        if (!BISDetector.isSafeToBootstrap()) {
            Log.d((String)TAG, (String)"This device is not supported. BeaconsInSpace Detector shutting down");
            bootstrapListener.onBootstrapFailure();
            return;
        }
        try {
            final BISDetector self = this;
            new BISConfiguration(this, new BISConfigurationInitializationListener(){

                @Override
                public void onInitializationSuccess(BISConfiguration initializedConfiguration) {
                    try {
                        BISDetector.this.configuration = initializedConfiguration;
                        BISDeviceUUID deviceUUID = new BISDeviceUUID(BISDetector.this.context);
                        BISDetector.this.uuid = deviceUUID.getDeviceUuid();
                        BISDetector.this.getUserADID();
                        if (!BISDetector.this.persistentStorage.isDeviceMetaDataCollected()) {
                            BISDetector.this.bootDeviceAtlas();
                        }
                        BISDetector.this.collectionManager = new BISCollectionManager(self, stickyService);
                        bootstrapListener.onBootstrapSuccess(self);
                    }
                    catch (Throwable t) {
                        BISDetector.this.reportCrash(t);
                    }
                }
            });
        }
        catch (Throwable t) {
            this.reportCrash(t);
        }
    }

    public IBinder onBind(Intent arg0) {
        return null;
    }

    public void onDestroy() {
        this.sendBroadcast(new Intent("BootstrapBeaconsInSpace"));
        super.onDestroy();
    }

    private static boolean isSafeToBootstrap() {
        if (Build.VERSION.SDK_INT < 18) {
            Log.e((String)TAG, (String)("BeaconsInSpace Detector Library does not run on Android: " + Build.VERSION.SDK_INT));
            return false;
        }
        return true;
    }

    static void performInitialSetup() {
        Log.i((String)TAG, (String)"BeaconsInSpace has bootstrapped successfully");
    }

    private void getUserADID() {
        if (this.context == null) {
            return;
        }
        Thread thread = new Thread(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        thread.start();
    }

    private void onUserADIDReceiveSuccess() {
        BISDetector.performInitialSetup();
    }

    private void onUserADIDReceiveFail() {
        BISDetector.performInitialSetup();
    }

    private void bootDeviceAtlas() {
        Intent transparentActivityIntent = new Intent(this.context, BISDeviceAtlas.class);
        transparentActivityIntent.setFlags(0x10000000);
        this.context.startActivity(transparentActivityIntent);
    }

    public BISCollectionManager getCollectionManager() {
        return this.collectionManager;
    }

    public BISConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getAPIKey() {
        return this.apiKey;
    }

    public Context getContext() {
        return this.context;
    }

    public String getADID() {
        return this.adid;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public BISPersistentStorage getPersistentStorage() {
        return this.persistentStorage;
    }

    public void reportCrash(Throwable throwable) {
        BISLog.e("BIS_CRASH", throwable.getClass().getName() + ": " + throwable.getMessage());
        try {
            BISConfiguration configuration = this.getConfiguration();
            BISNetworkingCrashThread task = configuration == null ? new BISNetworkingCrashThread("https://sentry.io/api/284645/store/", "3d915666beba410c89fe6cb9a3034539", "512bdf97ca284100b0eed543bca78654", throwable) : new BISNetworkingCrashThread(configuration.sentryUrl, configuration.sentryKey, configuration.sentrySecret, throwable);
            task.start();
        }
        catch (Throwable crashThrowable) {
            BISLog.e("BIS_CRASH_REPORTING", throwable.getClass().getName() + ": " + throwable.getMessage());
        }
    }

    static /* synthetic */ String access$802(BISDetector x0, String x1) {
        x0.adid = x1;
        return x0.adid;
    }

    static /* synthetic */ String access$800(BISDetector x0) {
        return x0.adid;
    }

    static enum ApplicationState {
        ACTIVE,
        INACTIVE,
        BACKGROUND;

    }
}

