/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import com.beaconsinspace.android.beacon.detector.BISCollectionEvent;
import com.beaconsinspace.android.beacon.detector.BISDetector;
import com.beaconsinspace.android.beacon.detector.BISLog;
import com.beaconsinspace.android.beacon.detector.BISNetworking;
import java.util.ArrayList;
import java.util.List;

public class BISReportingManager {
    private int bufferHead = 0;
    private int bufferSize = 1000;
    private BISCollectionEvent[] buffer;
    private boolean isBatchReporting = false;
    private final BISDetector detector;

    public BISReportingManager(BISDetector detector) {
        this.detector = detector;
        this.buffer = new BISCollectionEvent[this.bufferSize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(BISCollectionEvent event) {
        BISCollectionEvent[] bISCollectionEventArray = this.buffer;
        synchronized (this.buffer) {
            this.buffer[this.bufferHead] = event;
            this.bufferHead = (this.bufferHead + 1) % this.bufferSize;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (!this.detector.getConfiguration().urlSingleEvent.isEmpty()) {
                this.reportSingle(this.detector.getConfiguration().urlSingleEvent);
            }
            return;
        }
    }

    public void report() {
        BISLog.d(this.getClass().getName(), "report()");
        if (!this.detector.getConfiguration().urlSingleEvent.isEmpty()) {
            this.reportSingle(this.detector.getConfiguration().urlSingleEvent);
        } else if (!this.detector.getConfiguration().urlBatchEvent.isEmpty()) {
            this.reportBatch(this.detector.getConfiguration().urlBatchEvent);
        }
    }

    private void reportSingle(List<String> urls) {
        for (int i = 0; i < this.buffer.length; ++i) {
            int tempBufferHead = (this.bufferHead + i) % this.bufferSize;
            BISCollectionEvent event = this.buffer[tempBufferHead];
            if (event == null) continue;
            this.reportSingleEvent(urls, event);
        }
    }

    private void reportSingleEvent(List<String> urls, BISCollectionEvent event) {
        String apiUrl;
        if (!urls.isEmpty() && (apiUrl = urls.get(0)) != null) {
            try {
                BISNetworking.reportSingleEvent(this.detector, apiUrl, event, this.detector.getConfiguration().bisData);
                this.removeEvent(event);
            }
            catch (Exception e) {
                BISLog.e(this.getClass().getName(), "reportSingleEvent(" + e.getMessage() + ")");
                ArrayList<String> newUrls = new ArrayList<String>();
                for (String newUrl : urls) {
                    if (newUrl.equals(apiUrl)) continue;
                    newUrls.add(newUrl);
                }
                this.reportSingleEvent(newUrls, event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void reportBatch(List<String> urls) {
        if (this.isBatchReporting) return;
        BISCollectionEvent[] bISCollectionEventArray = this.buffer;
        synchronized (this.buffer) {
            if (this.buffer.length <= 0) return;
            this.isBatchReporting = true;
            this.reportBatchEvent(urls, this.buffer);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void reportBatchEvent(List<String> urls, BISCollectionEvent[] events) {
        block10: {
            if (!urls.isEmpty()) {
                String apiUrl = urls.get(0);
                if (apiUrl != null) {
                    try {
                        ArrayList<BISCollectionEvent> eventsList = new ArrayList<BISCollectionEvent>();
                        for (BISCollectionEvent event : events) {
                            if (event == null) continue;
                            eventsList.add(event);
                        }
                        BISNetworking.reportBatchEvent(this.detector, apiUrl, eventsList, this.detector.getConfiguration().bisData);
                        for (BISCollectionEvent event : eventsList) {
                            this.removeEvent(event);
                        }
                        this.isBatchReporting = false;
                    }
                    catch (Exception e) {
                        BISLog.e(this.getClass().getName(), "reportBatchEvent(" + e.getMessage() + ")");
                        ArrayList<String> newUrls = new ArrayList<String>();
                        for (String newUrl : urls) {
                            if (newUrl.equals(apiUrl)) continue;
                            newUrls.add(newUrl);
                        }
                        if (newUrls.isEmpty()) {
                            this.isBatchReporting = false;
                            BISLog.e(this.getClass().getName(), "Failed to report batch event.");
                            break block10;
                        }
                        this.reportBatchEvent(newUrls, events);
                    }
                } else {
                    this.isBatchReporting = false;
                }
            } else {
                this.isBatchReporting = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEvent(BISCollectionEvent eventToDelete) {
        BISCollectionEvent[] bISCollectionEventArray = this.buffer;
        synchronized (this.buffer) {
            for (int i = 0; i < this.buffer.length; ++i) {
                BISCollectionEvent event = this.buffer[i];
                if (event == null || !event.equals(eventToDelete)) continue;
                this.buffer[i] = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

