/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.bluetooth.BluetoothAdapter;
import android.location.Location;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Base64;
import com.beaconsinspace.android.beacon.detector.BISCollectionEvent;
import com.beaconsinspace.android.beacon.detector.BISDetector;
import com.beaconsinspace.android.beacon.detector.BISLog;
import com.beaconsinspace.android.beacon.detector.BISNetworkingEventTask;
import com.beaconsinspace.android.beacon.detector.BISNetworkingEventsTask;
import com.beaconsinspace.android.beacon.detector.BISNetworkingGetTask;
import com.google.android.gms.location.Geofence;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class BISNetworking {
    private static final String TAG = "BIS_NETWORKING";
    static final String BIS_BASE_URL = "https://api.beaconsinspace.com";
    static final String BIS_BASE_ENDPOINT = "/v1/secure/initialize?uam=1";
    static final String BIS_URL_INITIALIZE = "https://api.beaconsinspace.com/v1/secure/initialize?uam=1";

    BISNetworking() {
    }

    @NonNull
    public static JSONObject getConfiguration(@NonNull BISDetector detector, String apiUrl) throws InterruptedException, ExecutionException, JSONException {
        BISNetworkingGetTask urlCaller = new BISNetworkingGetTask(detector);
        urlCaller.execute(new String[]{apiUrl});
        String responseString = (String)urlCaller.get();
        if (responseString == null) {
            throw new JSONException("response is null");
        }
        return new JSONObject(responseString);
    }

    @NonNull
    public static List<Geofence> getGeofences(@NonNull BISDetector detector, @NonNull String apiUrl, @NonNull Location location) throws ExecutionException, InterruptedException, JSONException {
        BISNetworkingGetTask urlCaller = new BISNetworkingGetTask(detector);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("latitude", Double.toString(location.getLatitude()));
        params.put("longitude", Double.toString(location.getLongitude()));
        params.put("gpsHorizontalAccuracy", Float.toString(location.getAccuracy()));
        params.put("gpsSpeed", Double.toString(location.getSpeed()));
        String apiUrlWithLocation = apiUrl + "?" + BISNetworking.encodeParams(params);
        urlCaller.execute(new String[]{apiUrlWithLocation});
        String responseString = (String)urlCaller.get();
        if (responseString == null) {
            throw new JSONException("response is null");
        }
        JSONObject response = new JSONObject(responseString);
        JSONObject data = response.getJSONObject("data");
        JSONArray array = data.getJSONArray("geofence");
        ArrayList<Geofence> geofences = new ArrayList<Geofence>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject geofenceJson = array.getJSONObject(i);
            double latitude = geofenceJson.getDouble("latitude");
            double longitude = geofenceJson.getDouble("longitude");
            float radius = (float)geofenceJson.getDouble("radius");
            Geofence geofence = new Geofence.Builder().setRequestId(latitude + "+" + longitude + "+" + radius).setCircularRegion(latitude, longitude, radius).setExpirationDuration(-1L).setTransitionTypes(7).setLoiteringDelay(30000).build();
            geofences.add(geofence);
        }
        return geofences;
    }

    public static Boolean reportSingleEvent(@NonNull BISDetector detector, @NonNull String apiUrl, @NonNull BISCollectionEvent event, @Nullable String bisData) throws Exception {
        BISNetworkingEventTask task = new BISNetworkingEventTask(detector, apiUrl, bisData);
        task.execute(new BISCollectionEvent[]{event});
        String result = (String)task.get();
        return result != null;
    }

    public static Boolean reportBatchEvent(@NonNull BISDetector detector, @NonNull String apiUrl, @NonNull List<BISCollectionEvent> events, @Nullable String bisData) throws Exception {
        if (events.isEmpty()) {
            return false;
        }
        BISLog.d(TAG, "reportBatchEvent(" + events.size() + ")");
        BISNetworkingEventsTask task = new BISNetworkingEventsTask(detector, apiUrl, bisData);
        task.execute(new List[]{events});
        String result = (String)task.get();
        return result != null;
    }

    public static String getAuthorizationHeader(BISDetector detector) {
        String USER_KEY = detector.getAPIKey();
        String PACKAGE_NAME = detector.getContext() != null ? detector.getContext().getPackageName() : "";
        String authString = USER_KEY + ":" + PACKAGE_NAME;
        byte[] authBytes = authString.getBytes();
        String base64AuthString = Base64.encodeToString((byte[])authBytes, (int)0, (int)authString.length(), (int)2);
        String authorizationHeader = "Basic " + base64AuthString;
        return authorizationHeader;
    }

    public static Map<String, String> getCommonRequestArguments(BISDetector detector) {
        String deviceMetaDataString;
        HashMap<String, String> common = new HashMap<String, String>();
        common.put("userId", detector.getUUID() != null && detector.getUUID().toString() != null ? detector.getUUID().toString() : "");
        common.put("userIdType", "AUUID");
        common.put("userId2", detector.getADID() != null ? detector.getADID() : "");
        common.put("userIdType2", "ADID");
        common.put("os", "ANDROID " + Build.VERSION.RELEASE);
        common.put("device", Build.DEVICE);
        common.put("brand", Build.BRAND);
        common.put("model", Build.MODEL);
        common.put("manufacturer", Build.MANUFACTURER);
        common.put("userAgent", System.getProperty("http.agent"));
        common.put("tz", TimeZone.getDefault().getID());
        common.put("language", Locale.getDefault().toString());
        common.put("country", Locale.getDefault().toString());
        common.put("sdkVersion", "2.0.4");
        common.put("creationTimeInEpochMillis", String.valueOf(System.currentTimeMillis()));
        common.put("isBluetoothEnabled", BISNetworking.isBluetoothEnabled() != false ? "1" : "0");
        if (detector.getPersistentStorage().isDeviceMetaDataCollected() && !detector.getPersistentStorage().isdeviceMetaDataSent() && (deviceMetaDataString = detector.getPersistentStorage().getDeviceMetaDataString()) != null) {
            detector.getPersistentStorage().setDeviceMetaDataSent(true);
            common.put("deviceMetaData", deviceMetaDataString);
        }
        return common;
    }

    public static Map<String, String> getLocationRequestArguments(Location location) {
        HashMap<String, String> request = new HashMap<String, String>();
        if (location != null) {
            request.put("gpsLatitude", Double.toString(location.getLatitude()));
            request.put("gpsLongitude", Double.toString(location.getLongitude()));
            request.put("gpsHorizontalAccuracy", Float.toString(location.getAccuracy()));
            request.put("gpsAltitude", Double.toString(location.getAltitude()));
            request.put("gpsSpeed", Float.toString(location.getSpeed()));
            request.put("gpsBearing", Float.toString(location.getBearing()));
        }
        return request;
    }

    public static String encodeParams(Map<String, String> parameters) {
        ArrayList<String> encoded = new ArrayList<String>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            try {
                if (entry.getValue() == null) continue;
                encoded.add(entry.getKey() + "=" + URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                BISLog.e(TAG, "UnsupportedEncodingException: " + e.getMessage());
            }
        }
        return TextUtils.join((CharSequence)"&", (Object[])encoded.toArray());
    }

    private static Boolean isBluetoothEnabled() {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter == null) {
            return false;
        }
        return adapter.isEnabled();
    }
}

