package com.beaconsinspace.android.beacon.detector;

import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

public class BISDetectorServicesListener extends BroadcastReceiver {

    static private final String TAG = "BIS_LISTENER";

    @Override
    public void onReceive(final Context context, final Intent intent) {
        String action = intent.getAction();

        BISLog.i(TAG, "Intent action: " + action);

        // Bluetooth state change
        if (action.equals(BluetoothAdapter.ACTION_STATE_CHANGED)) {
            final int state = intent.getIntExtra(BluetoothAdapter.EXTRA_STATE, BluetoothAdapter.ERROR);

            BISDetector detector = new BISDetector(context);
            detector.bootstrap();

            BISCollectionManager collectionManager = detector.getCollectionManager();

            if (collectionManager != null) {
                switch (state) {
                    case BluetoothAdapter.STATE_OFF:
                        collectionManager.stopRanging();
                        break;
                    case BluetoothAdapter.STATE_TURNING_OFF:
                        break;
                    case BluetoothAdapter.STATE_ON:
                        collectionManager.startRanging();
                        break;
                    case BluetoothAdapter.STATE_TURNING_ON:
                        break;
                    default:
                        break;
                }
            }
        }
    }
}
