/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.app.job.JobService;
import com.beaconsinspace.android.beacon.detector.BISCollectionManager;
import com.beaconsinspace.android.beacon.detector.BISConfiguration;
import com.beaconsinspace.android.beacon.detector.BISDetector;
import com.beaconsinspace.android.beacon.detector.BISPersistentStorage;
import java.util.Timer;
import java.util.TimerTask;

@TargetApi(value=26)
public class BISJobService
extends JobService {
    private Timer timer;
    private TimerTask timerTask;

    public boolean onStartJob(final JobParameters jobParameters) {
        BISDetector detector = BISDetector.getSharedInstance();
        if (BISDetector.appContext == null) {
            String apiKey = BISPersistentStorage.getString("BIS_API_KEY");
            if (apiKey == null) {
                return false;
            }
            detector.bootstrap(apiKey, this.getApplicationContext());
        }
        Integer interval = BISConfiguration.getCurrentConfiguration().backgroundDataCollectionMaxLength;
        BISCollectionManager collectionManager = BISDetector.getSharedInstance().getCollectionManager(this.getApplicationContext());
        if (collectionManager != null) {
            collectionManager.startLocationGathering();
            this.timer = new Timer();
            this.timerTask = new TimerTask(){

                @Override
                public void run() {
                    BISJobService.this.jobFinished(jobParameters, false);
                }
            };
            this.timer.schedule(this.timerTask, interval.intValue());
            return true;
        }
        return false;
    }

    public boolean onStopJob(JobParameters jobParameters) {
        BISCollectionManager collectionManager = BISDetector.getSharedInstance().getCollectionManager(this.getApplicationContext());
        if (collectionManager != null) {
            collectionManager.stopLocationGathering();
        }
        return false;
    }
}

