/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.beaconsinspace.android.beacon.detector.BISCollectionEvent;
import com.beaconsinspace.android.beacon.detector.BISCollectionManager;
import com.beaconsinspace.android.beacon.detector.BISDetector;
import com.beaconsinspace.android.beacon.detector.BISLog;
import com.beaconsinspace.android.beacon.detector.BISPersistentStorage;
import com.google.android.gms.location.GeofencingEvent;

public class BISGeofenceTransitionsIntentService
extends IntentService {
    public static final String INTENT = "BISGeofenceTransitionsIntentService";
    private static final String TAG = "GeofenceTransitionsIS";

    public BISGeofenceTransitionsIntentService() {
        super(TAG);
    }

    protected void onHandleIntent(Intent intent) {
        BISCollectionManager collectionManager;
        GeofencingEvent geofencingEvent = GeofencingEvent.fromIntent((Intent)intent);
        if (geofencingEvent.hasError()) {
            String errorMessage = "Geofence error: " + geofencingEvent.getErrorCode();
            Log.e((String)TAG, (String)errorMessage);
            return;
        }
        BISDetector detector = BISDetector.getSharedInstance();
        if (BISDetector.appContext == null) {
            String apiKey = BISPersistentStorage.getString("BIS_API_KEY");
            if (apiKey == null) {
                return;
            }
            detector.bootstrap(apiKey, this.getApplicationContext());
        }
        if ((collectionManager = BISDetector.getSharedInstance().getCollectionManager(this.getApplicationContext())) != null) {
            BISCollectionEvent.BISCollectionEventDirection direction = BISCollectionEvent.BISCollectionEventDirection.None;
            switch (geofencingEvent.getGeofenceTransition()) {
                case 1: {
                    BISLog.d(TAG, "GEOFENCE_TRANSITION_ENTER");
                    direction = BISCollectionEvent.BISCollectionEventDirection.Enter;
                    break;
                }
                case 2: {
                    BISLog.d(TAG, "GEOFENCE_TRANSITION_EXIT");
                    direction = BISCollectionEvent.BISCollectionEventDirection.Exit;
                    break;
                }
                case 4: {
                    BISLog.d(TAG, "GEOFENCE_TRANSITION_DWELL");
                    direction = BISCollectionEvent.BISCollectionEventDirection.Dwell;
                    break;
                }
            }
            BISCollectionEvent event = new BISCollectionEvent((Context)this, BISCollectionEvent.BISCollectionEventType.GeoFence, direction, geofencingEvent.getTriggeringLocation());
            collectionManager.triggerEvent(event);
        }
    }
}

