/*
 * Copyright (c) Afilias Technologies Ltd 2017. All rights reserved.
 */

package com.beaconsinspace.android.beacon.detector.deviceatlas;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author Afilias Technologies Ltd
 */
class WebProperties implements Properties {
    private static final String TAG = WebProperties.class.getName();

    private static final String SYSTEM_USER_AGENT = "systemUserAgent";
    private static final String WEBVIEW_USER_AGENT = "webviewUserAgent";

    private String webviewUserAgent;
    public void setWebviewUserAgent(String webviewUserAgent) {
        this.webviewUserAgent = webviewUserAgent;
    }


    public JSONObject getProperties() throws JSONException {
        JSONObject props = new JSONObject();
        props.put(SYSTEM_USER_AGENT, System.getProperty("http.agent"));
        if(webviewUserAgent != null) {
            props.put(WEBVIEW_USER_AGENT, webviewUserAgent);
        }

        return props;
    }


}
