package com.beaconsinspace.android.beacon.detector;

import android.app.Activity;
import android.util.Log;

import com.beaconsinspace.android.beacon.detector.deviceatlas.DataCollector;
import com.beaconsinspace.android.beacon.detector.deviceatlas.HandleDataCallback;

import org.json.JSONObject;

/**
 * Created by Akshayraj on 2/9/17.
 */

public class BISDeviceAtlas extends Activity {

    private static final String TAG = "BISDeviceAtlas";

    @Override
    protected void onStart() {
        super.onStart();
        try
        {
            DataCollector collector = new DataCollector(this, new HandleDataCallback() {

                @Override
                public void handleData(String deviceMetaData) {
                    if(deviceMetaData != null) {
                        BISPersistentStorage.storeDeviceMetaData(deviceMetaData);
                        BISPersistentStorage.setDeviceMetaDataCollected(true);
                    }
                    //finish the Activity
                    finish();
                }
            });
        }
        catch( Exception e )
        {
            Log.e(TAG,"Failed to collect device information: "+e.getMessage());
        }
    }
}
