/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.app.Activity;
import android.app.Application;
import android.app.Service;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import com.beaconsinspace.android.beacon.detector.BISCollectionManager;
import com.beaconsinspace.android.beacon.detector.BISConfiguration;
import com.beaconsinspace.android.beacon.detector.BISDeviceAtlas;
import com.beaconsinspace.android.beacon.detector.BISDeviceUUID;
import com.beaconsinspace.android.beacon.detector.BISJobService;
import com.beaconsinspace.android.beacon.detector.BISLog;
import com.beaconsinspace.android.beacon.detector.BISLogDelegate;
import com.beaconsinspace.android.beacon.detector.BISPersistentStorage;
import java.util.UUID;

public class BISDetector
extends Service
implements Application.ActivityLifecycleCallbacks {
    public static String SDK_VERSION = "2.0.2";
    private static final String TAG = "BIS_API";
    static String API_KEY = "";
    static String ADID = "";
    static UUID UUID;
    private static BISDetector sharedInstance;
    static BISLogDelegate logDelegate;
    private BISCollectionManager collectionManager;
    private Thread primaryProcessThread;
    static Context appContext;
    public ApplicationState applicationState = ApplicationState.BACKGROUND;

    public static BISDetector getSharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new BISDetector();
        }
        return sharedInstance;
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
        this.applicationState = ApplicationState.INACTIVE;
    }

    public void onActivityStarted(Activity activity) {
        this.applicationState = ApplicationState.ACTIVE;
    }

    public void onActivityResumed(Activity activity) {
        this.applicationState = ApplicationState.ACTIVE;
    }

    public void onActivityPaused(Activity activity) {
        this.applicationState = ApplicationState.BACKGROUND;
    }

    public void onActivityStopped(Activity activity) {
        this.applicationState = ApplicationState.BACKGROUND;
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public static void configure(String key, Context ctx) {
        Log.d((String)TAG, (String)("Configuring BISDetector SDK " + SDK_VERSION));
        API_KEY = key;
        appContext = ctx.getApplicationContext();
        logDelegate = null;
        if (appContext instanceof Application) {
            Application application = (Application)appContext;
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)BISDetector.getSharedInstance());
        }
        BISPersistentStorage.storeString("BIS_API_KEY", key);
        if (!BISPersistentStorage.isDeviceMetaDataCollected()) {
            BISDetector.getSharedInstance().bootDeviceAtlas();
        }
        BISDetector.scheduleJob(appContext);
        if (Build.VERSION.SDK_INT >= 26) {
            BISDetector detector = BISDetector.getSharedInstance();
            if (detector != null) {
                detector.foregroundService();
            }
        } else {
            appContext.sendBroadcast(new Intent("BootstrapBeaconsInSpace"));
        }
    }

    private void foregroundService() {
        if (this.primaryProcessThread == null) {
            this.primaryProcessThread = new Thread(){

                @Override
                public void run() {
                    try {
                        BISDetector.this.bootstrap(API_KEY, appContext);
                    }
                    catch (Throwable e) {
                        BISLog.e(BISDetector.TAG, e.getMessage());
                    }
                }
            };
            this.primaryProcessThread.start();
        }
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        appContext = this.getApplicationContext();
        API_KEY = BISPersistentStorage.getString("BIS_API_KEY");
        if (this.primaryProcessThread == null) {
            this.primaryProcessThread = new Thread(){

                @Override
                public void run() {
                    try {
                        BISDetector.this.bootstrap(API_KEY, appContext);
                    }
                    catch (Throwable e) {
                        BISLog.e(BISDetector.TAG, e.getMessage());
                    }
                }
            };
            this.primaryProcessThread.start();
        }
        return 1;
    }

    private static void scheduleJob(Context context) {
        if (Build.VERSION.SDK_INT >= 26) {
            BISLog.d(TAG, "Scheduling job");
            int jobId = 1337;
            ComponentName mServiceComponent = new ComponentName(context, BISJobService.class);
            JobInfo.Builder builder = new JobInfo.Builder(jobId, mServiceComponent);
            builder.setPeriodic((long)BISConfiguration.getCurrentConfiguration().locationMonitoringInterval.intValue());
            builder.setRequiredNetworkType(1);
            JobScheduler tm = (JobScheduler)context.getSystemService("jobscheduler");
            tm.cancel(jobId);
            tm.schedule(builder.build());
        }
    }

    public void bootstrap(String key, Context ctx) {
        if (!BISDetector.isSafeToBootstrap()) {
            Log.d((String)TAG, (String)"This device is not supported. BeaconsInSpace Detector shutting down");
            return;
        }
        API_KEY = key != null ? key : "";
        BISConfiguration.getCurrentConfiguration();
        BISDeviceUUID deviceUUID = new BISDeviceUUID(ctx);
        UUID = deviceUUID.getDeviceUuid();
        BISDetector.getUserADID();
        this.collectionManager = new BISCollectionManager(ctx);
    }

    public IBinder onBind(Intent arg0) {
        return null;
    }

    public void onDestroy() {
        this.sendBroadcast(new Intent("BootstrapBeaconsInSpace"));
        super.onDestroy();
    }

    private static boolean isSafeToBootstrap() {
        if (Build.VERSION.SDK_INT < 18) {
            Log.e((String)TAG, (String)("BeaconsInSpace Detector Library does not run on Android: " + Build.VERSION.SDK_INT));
            return false;
        }
        return true;
    }

    static void performInitialSetup() {
        Log.i((String)TAG, (String)"BeaconsInSpace has bootstrapped successfully");
    }

    static void getUserADID() {
        if (appContext == null) {
            return;
        }
        Thread thread = new Thread(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        thread.start();
    }

    static void onUserADIDReceiveSuccess() {
        BISDetector.performInitialSetup();
    }

    static void onUserADIDReceiveFail() {
        BISDetector.performInitialSetup();
    }

    private void bootDeviceAtlas() {
        Intent transparentActivityIntent = new Intent(appContext, BISDeviceAtlas.class);
        transparentActivityIntent.setFlags(0x10000000);
        appContext.startActivity(transparentActivityIntent);
    }

    public static Context getContext() {
        return appContext;
    }

    public BISCollectionManager getCollectionManager(Context context) {
        if (this.collectionManager != null) {
            return this.collectionManager;
        }
        API_KEY = BISPersistentStorage.getString("BIS_API_KEY");
        String apiKey = API_KEY;
        if (apiKey != null) {
            this.bootstrap(apiKey, context);
            return this.collectionManager;
        }
        return null;
    }

    static enum ApplicationState {
        ACTIVE,
        INACTIVE,
        BACKGROUND;

    }
}

