/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.bluetooth.le.ScanResult;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.beaconsinspace.android.beacon.detector.BISCollectionEvent;
import com.beaconsinspace.android.beacon.detector.BISCollectionManager;
import com.beaconsinspace.android.beacon.detector.BISDetector;
import com.beaconsinspace.android.beacon.detector.BISLog;
import com.beaconsinspace.android.beacon.detector.BISPersistentStorage;
import java.util.ArrayList;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconParser;

public class BISBeaconReceiver
extends BroadcastReceiver {
    private static String TAG = "BISBeaconReceiver";

    public void onReceive(Context context, Intent intent) {
        int bleCallbackType;
        if (Build.VERSION.SDK_INT >= 26 && (bleCallbackType = intent.getIntExtra("android.bluetooth.le.extra.CALLBACK_TYPE", -1)) != -1) {
            BISCollectionManager collectionManager;
            BISLog.d(TAG, "Passive background scan callback type: " + bleCallbackType);
            final ArrayList scanResults = intent.getParcelableArrayListExtra("android.bluetooth.le.extra.LIST_SCAN_RESULT");
            BISDetector detector = BISDetector.getSharedInstance();
            if (BISDetector.appContext == null) {
                String apiKey = BISPersistentStorage.getString("BIS_API_KEY");
                if (apiKey == null) {
                    return;
                }
                detector.bootstrap(apiKey, context);
            }
            if ((collectionManager = BISDetector.getSharedInstance().getCollectionManager(context)) != null) {
                final BroadcastReceiver.PendingResult result = this.goAsync();
                final Context theContext = context;
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        if (Build.VERSION.SDK_INT >= 26) {
                            for (ScanResult scanResult : scanResults) {
                                BeaconParser parser = new BeaconParser();
                                Beacon beacon = parser.fromScanData(scanResult.getScanRecord().getBytes(), scanResult.getRssi(), scanResult.getDevice());
                                BISCollectionEvent event = new BISCollectionEvent(theContext, BISCollectionEvent.BISCollectionEventType.BeaconInteraction, BISCollectionEvent.BISCollectionEventDirection.Enter, beacon);
                                event.location = collectionManager.getLastKnownLocation();
                                collectionManager.triggerEvent(event);
                            }
                            collectionManager.startLocationGathering();
                        }
                        result.finish();
                    }
                };
                thread.start();
            }
        }
    }
}

