/*
 * Copyright (c) Afilias Technologies Ltd 2017. All rights reserved.
 */


package com.beaconsinspace.android.beacon.detector.deviceatlas;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author Afilias Technologies Ltd
 */
class UsbProperties {

    private static final String USB_FILE_PATH = "/sys/devices/virtual/android_usb/android0/";
    private static final String[] FILE_NAMES = {"iManufacturer", "iProduct", "idProduct", "idVendor"};

    public static JSONObject getProperties() throws JSONException {
        JSONObject props = new JSONObject();

        for(String name : FILE_NAMES) {
            try {
                String value = FileUtil.loadFirstLine(USB_FILE_PATH + name);
                if(value != null) {
                    props.put(name, value.trim());
                }
            } catch (Exception e) {
                props.put("ERROR", "Can't read data for "+name+" - "+ e.getMessage());
            }
        }

        return props;
    }


}
