/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector.deviceatlas;

import android.app.Activity;
import android.util.Log;
import com.beaconsinspace.android.beacon.detector.deviceatlas.DataCollectorTask;
import com.beaconsinspace.android.beacon.detector.deviceatlas.HandleDataCallback;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DataCollector {
    private static final String TAG = DataCollector.class.getName();
    private static final long TIMEOUT_SEC = 10L;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
    public static final String INFO = "info";
    private static final String VERSION = "version";
    private static final String SOURCE = "source";
    private static final String VERSION_NUM = "0.2";
    private static final String DATE = "date";
    public static final String DATA = "data";
    private static final String ERRORS = "errors";
    private Activity activityContext;
    private HandleDataCallback callback;
    private JSONObject allData = new JSONObject();

    public DataCollector(Activity activityContext, HandleDataCallback callback) {
        this.activityContext = activityContext;
        this.callback = callback;
        this.collectStats();
    }

    private void collectStats() {
        final DataCollector master = this;
        try {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ExecutorService executor = Executors.newSingleThreadExecutor();
                    Future<Void> dataResult = executor.submit(new DataCollectorTask(DataCollector.this.activityContext, master));
                    try {
                        dataResult.get(10L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException e) {
                        dataResult.cancel(true);
                        DataCollector.this.addError(DataCollector.this.prepareException(e));
                    }
                    finally {
                        executor.shutdownNow();
                        DataCollector.this.doCallback();
                    }
                }
            }).start();
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addProperties(String key, Object props) {
        try {
            JSONObject jSONObject = this.allData;
            synchronized (jSONObject) {
                this.allData.put(key, props);
            }
        }
        catch (JSONException e) {
            this.addError(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addError(String err) {
        if (err == null) {
            return;
        }
        Log.d((String)TAG, (String)err);
        JSONObject jSONObject = this.allData;
        synchronized (jSONObject) {
            try {
                JSONArray errors = this.allData.has(ERRORS) ? this.allData.getJSONArray(ERRORS) : new JSONArray();
                errors.put((Object)err);
                this.allData.put(ERRORS, (Object)errors);
            }
            catch (JSONException e) {
                Log.d((String)TAG, (String)e.toString());
            }
        }
    }

    private String prepareException(Throwable t) {
        try {
            for (int count = 0; t.getCause() != null && count < 50; ++count) {
                t = t.getCause();
            }
            StringBuilder sb = new StringBuilder();
            sb.append(t.toString());
            sb.append(" - ");
            String packageName = this.getClass().getPackage().getName();
            for (StackTraceElement st : t.getStackTrace()) {
                String className = st.getClassName();
                if (!className.startsWith(packageName)) continue;
                className = className.substring(packageName.length() + 1);
                sb.append(className).append(".").append(st.getMethodName()).append("(").append(st.getLineNumber()).append(")");
                break;
            }
            return sb.toString();
        }
        catch (Exception e) {
            return t.getMessage();
        }
    }

    private void doCallback() {
        final String toReturn = this.prepareFinalJsonStr();
        this.activityContext.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                DataCollector.this.callback.handleData(toReturn);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String prepareFinalJsonStr() {
        String jsonStr;
        JSONObject jSONObject = this.allData;
        synchronized (jSONObject) {
            try {
                JSONObject info = new JSONObject();
                info.put(VERSION, (Object)VERSION_NUM);
                info.put(DATE, (Object)DATE_FORMAT.format(new Date()));
                info.put(SOURCE, (Object)this.getAppName());
                JSONObject all = new JSONObject();
                all.put(INFO, (Object)info);
                all.put(DATA, (Object)this.allData);
                jsonStr = all.toString();
            }
            catch (JSONException ex) {
                jsonStr = "";
                Log.d((String)TAG, (String)ex.toString());
            }
        }
        return jsonStr;
    }

    private String getAppName() {
        return this.activityContext.getApplicationInfo().loadLabel(this.activityContext.getPackageManager()).toString();
    }

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

