/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.os.Build;
import com.beaconsinspace.android.beacon.detector.BISException;
import com.beaconsinspace.android.beacon.detector.BISLog;
import com.beaconsinspace.android.beacon.detector.BISNetworking;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class BISConfiguration {
    private static BISConfiguration instance = null;
    private static final String TAG = "BIS_CONFIG";
    static final String KEY_foregroundBluetoothScanPeriod = "foregroundBluetoothScanPeriod";
    static final String KEY_foregroundBluetoothBetweenScanPeriod = "foregroundBluetoothBetweenScanPeriod";
    static final String KEY_backgroundBluetoothScanPeriod = "backgroundBluetoothScanPeriod";
    static final String KEY_backgroundBluetoothBetweenScanPeriod = "backgroundBluetoothBetweenScanPeriod";
    static final String KEY_locationMonitoringInterval = "locationMonitoringInterval";
    static final String KEY_unsupportedAndroidModels = "unsupportedAndroidModels";
    static final String KEY_collectForegroundProcess = "collectForegroundProcess";
    static final String KEY_eventCollectionFilterLength = "eventCollectionFilterLength";
    static final String KEY_urlConfiguration = "urlConfiguration";
    static final String KEY_urlSingleEvent = "urlSingleEvent";
    static final String KEY_urlBeaconIdentifiers = "urlBeaconIdentifiers";
    static final String KEY_urlBatchEvent = "urlBatchEvent";
    static final String KEY_urlGeofence = "urlGeofence";
    static final String KEY_configurationExpiration = "configurationExpiration";
    static final String KEY_batchEventMax = "batchEventMax";
    static final String KEY_backgroundDataCollectionMaxLength = "backgroundDataCollectionMaxLength";
    static final String KEY_foregroundDataCollectionMaxLength = "foregroundDataCollectionMaxLength";
    static final String KEY_bisData = "bisData";
    static final String KEY_signficantLocationChangeDistance = "signficantLocationChangeDistance";
    static final String KEY_batchEventInterval = "batchEventInterval";
    static final String URL_configurationRetry1 = "https://E8C34AB4-CFC3-43C8-9484-E0625D47303E.net/v1/secure/initialize?uam=1";
    static final String URL_configurationRetry2 = "https://FF4415AE-151D-4C70-B3D7-E883A1CB84EE.net/v1/secure/initialize?uam=1";
    static final String URL_configurationRetry3 = "https://438CDE19-0278-4CCD-9E92-32CA51E83021.net/v1/secure/initialize?uam=1";
    public Integer foregroundBluetoothScanPeriod = 2000;
    public Integer foregroundBluetoothBetweenScanPeriod = 60000;
    public Integer backgroundBluetoothScanPeriod = 10000;
    public Integer backgroundBluetoothBetweenScanPeriod = 60000;
    public Integer locationMonitoringInterval = 5340000;
    public Integer eventCollectionFilterLength = 0;
    public List<String> unsupportedAndroidModels = new ArrayList<String>();
    public Integer collectForegroundProcess = -1;
    public Integer configurationExpiration = 10800000;
    public Integer batchEventMax = 1000;
    public Integer backgroundDataCollectionMaxLength = 0;
    public Integer foregroundDataCollectionMaxLength = 0;
    public Integer signficantLocationChangeDistance = 0;
    public List<String> defaultUrlConfiguration = new ArrayList<String>(Arrays.asList("https://api.beaconsinspace.com/v1/secure/initialize?uam=1"));
    public List<String> urlConfiguration = new ArrayList<String>(Arrays.asList("https://api.beaconsinspace.com/v1/secure/initialize?uam=1"));
    public List<String> urlSingleEvent = new ArrayList<String>();
    public List<String> urlBeaconIdentifiers = new ArrayList<String>();
    public List<String> urlBatchEvent = new ArrayList<String>();
    public List<String> urlGeofence = new ArrayList<String>();
    public List<Integer> batchEventInterval = new ArrayList<Integer>();
    public String bisData = null;
    private BISConfigurationState state = BISConfigurationState.Default;
    private List<String> stateConfigurationUrls = this.defaultUrlConfiguration;
    private Integer stateRetryCount = 0;
    private Date configurationReferenceDate = new Date();
    private Timer configurationTimer = null;

    private BISConfiguration() {
        this.fetch();
    }

    public static BISConfiguration getCurrentConfiguration() {
        if (instance == null) {
            instance = new BISConfiguration();
        }
        return instance;
    }

    private void fetch() {
        try {
            BISLog.d(TAG, "Getting Configuration");
            this.fetch(this.stateConfigurationUrls);
        }
        catch (BISException exception) {
            BISLog.d(this.getClass().getName(), "Attempting to fetch configuration again...");
            Integer interval = this.fetchConfigurationFailed();
            this.setTimer(interval);
        }
    }

    private void fetch(List<String> configurationUrls) throws BISException {
        if (configurationUrls.isEmpty()) {
            BISLog.d(this.getClass().getName(), "Couldn't fetch updated configuration");
            throw new BISException("Couldn't fetch updated configuration");
        }
        String configurationUrl = configurationUrls.get(0);
        BISLog.d(this.getClass().getName(), "Fetching configuration: " + configurationUrl);
        try {
            JSONObject response = BISNetworking.getSharedManger().getConfiguration(configurationUrl);
            this.processResponse(response);
        }
        catch (Exception e) {
            ArrayList<String> newConfigurationUrls = new ArrayList<String>();
            for (String url : configurationUrls) {
                if (url.equals(configurationUrl)) continue;
                newConfigurationUrls.add(url);
            }
            this.fetch(newConfigurationUrls);
        }
    }

    private void setTimer(Integer milliseconds) {
        this.stopTimer();
        this.configurationTimer = new Timer();
        final BISConfiguration self = this;
        TimerTask configurationTimerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    self.fetch();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        };
        this.configurationTimer.schedule(configurationTimerTask, milliseconds.intValue());
    }

    private void stopTimer() {
        if (this.configurationTimer != null) {
            this.configurationTimer.cancel();
            this.configurationTimer = null;
        }
    }

    private void processResponse(JSONObject totalResponse) throws JSONException {
        JSONObject response = totalResponse.getJSONObject("data");
        if (response == null) {
            throw new JSONException("Data key not found for configuration");
        }
        Iterator keyIterator = response.keys();
        while (keyIterator.hasNext()) {
            String key;
            switch (key = (String)keyIterator.next()) {
                case "foregroundBluetoothScanPeriod": {
                    this.foregroundBluetoothScanPeriod = response.getInt(key);
                    break;
                }
                case "foregroundBluetoothBetweenScanPeriod": {
                    this.foregroundBluetoothBetweenScanPeriod = response.getInt(key);
                    break;
                }
                case "backgroundBluetoothScanPeriod": {
                    this.backgroundBluetoothScanPeriod = response.getInt(key);
                    break;
                }
                case "backgroundBluetoothBetweenScanPeriod": {
                    this.backgroundBluetoothBetweenScanPeriod = response.getInt(key);
                    break;
                }
                case "locationMonitoringInterval": {
                    this.locationMonitoringInterval = response.getInt(key);
                    break;
                }
                case "unsupportedAndroidModels": {
                    ArrayList<String> models = new ArrayList<String>();
                    JSONArray modelsArray = response.getJSONArray(key);
                    if (modelsArray != null) {
                        int len = modelsArray.length();
                        for (int i = 0; i < len; ++i) {
                            models.add(modelsArray.getString(i));
                        }
                    }
                    this.unsupportedAndroidModels = models;
                    break;
                }
                case "collectForegroundProcess": {
                    this.collectForegroundProcess = response.getInt(key);
                    break;
                }
                case "configurationExpiration": {
                    this.configurationExpiration = response.getInt(key);
                    break;
                }
                case "batchEventMax": {
                    this.batchEventMax = response.getInt(key);
                    break;
                }
                case "backgroundDataCollectionMaxLength": {
                    this.backgroundDataCollectionMaxLength = response.getInt(key);
                    break;
                }
                case "foregroundDataCollectionMaxLength": {
                    this.foregroundDataCollectionMaxLength = response.getInt(key);
                    break;
                }
                case "eventCollectionFilterLength": {
                    this.eventCollectionFilterLength = response.getInt(key);
                    break;
                }
                case "signficantLocationChangeDistance": {
                    this.signficantLocationChangeDistance = response.getInt(key);
                    break;
                }
                case "urlConfiguration": {
                    ArrayList<String> config = new ArrayList<String>();
                    JSONArray configArray = response.getJSONArray(key);
                    if (configArray != null) {
                        int len = configArray.length();
                        for (int i = 0; i < len; ++i) {
                            config.add(configArray.getString(i));
                        }
                    }
                    this.urlConfiguration = config;
                    break;
                }
                case "urlSingleEvent": {
                    ArrayList<String> singleEvent = new ArrayList<String>();
                    JSONArray singleEventArray = response.getJSONArray(key);
                    if (singleEventArray != null) {
                        int len = singleEventArray.length();
                        for (int i = 0; i < len; ++i) {
                            singleEvent.add(singleEventArray.getString(i));
                        }
                    }
                    this.urlSingleEvent = singleEvent;
                    break;
                }
                case "urlBeaconIdentifiers": {
                    ArrayList<String> beacons = new ArrayList<String>();
                    JSONArray beaconsArray = response.getJSONArray(key);
                    if (beaconsArray != null) {
                        int len = beaconsArray.length();
                        for (int i = 0; i < len; ++i) {
                            beacons.add(beaconsArray.getString(i));
                        }
                    }
                    this.urlBeaconIdentifiers = beacons;
                    break;
                }
                case "urlBatchEvent": {
                    ArrayList<String> batchEvent = new ArrayList<String>();
                    JSONArray batchEventArray = response.getJSONArray(key);
                    if (batchEventArray != null) {
                        int len = batchEventArray.length();
                        for (int i = 0; i < len; ++i) {
                            batchEvent.add(batchEventArray.getString(i));
                        }
                    }
                    this.urlBatchEvent = batchEvent;
                    break;
                }
                case "urlGeofence": {
                    ArrayList<String> geofences = new ArrayList<String>();
                    JSONArray geofencesArray = response.getJSONArray(key);
                    if (geofencesArray != null) {
                        int len = geofencesArray.length();
                        for (int i = 0; i < len; ++i) {
                            geofences.add(geofencesArray.getString(i));
                        }
                    }
                    this.urlGeofence = geofences;
                    break;
                }
                case "bisData": {
                    this.bisData = response.getString(key);
                    break;
                }
                case "batchEventInterval": {
                    ArrayList<Integer> intervals = new ArrayList<Integer>();
                    JSONArray responseEventIntervals = response.getJSONArray(KEY_batchEventInterval);
                    if (responseEventIntervals != null) {
                        int len = responseEventIntervals.length();
                        for (int i = 0; i < len; ++i) {
                            intervals.add(responseEventIntervals.getInt(i));
                        }
                    }
                    this.batchEventInterval = intervals;
                    break;
                }
            }
        }
        if (this.urlConfiguration != null && !this.urlConfiguration.isEmpty()) {
            this.state = BISConfigurationState.Provided;
            this.stateConfigurationUrls = this.urlConfiguration;
            this.stateRetryCount = 0;
        }
        if (this.configurationExpiration > 0) {
            this.setTimer(this.configurationExpiration);
        }
    }

    private Integer fetchConfigurationFailed() {
        Date now = new Date();
        this.stateRetryCount = this.stateRetryCount + 1;
        switch (this.state) {
            case Default: {
                if (this.stateRetryCount < 10) break;
                if (this.urlConfiguration != null && !this.urlConfiguration.isEmpty()) {
                    this.state = BISConfigurationState.Provided;
                    this.stateConfigurationUrls = this.urlConfiguration;
                    this.stateRetryCount = 0;
                    break;
                }
                this.state = BISConfigurationState.DefaultRetry;
                this.stateConfigurationUrls = this.defaultUrlConfiguration;
                this.stateRetryCount = 0;
                break;
            }
            case Provided: {
                if (this.stateRetryCount < 10) break;
                this.state = BISConfigurationState.DefaultRetry;
                this.stateConfigurationUrls = this.defaultUrlConfiguration;
                this.stateRetryCount = 0;
                break;
            }
            case DefaultRetry: {
                if (this.stateRetryCount < 10) break;
                this.state = BISConfigurationState.Fallback1;
                ArrayList<String> newUrls = new ArrayList<String>();
                newUrls.add("https://api.beaconsinspace.com/v1/secure/initialize?uam=1");
                newUrls.add(URL_configurationRetry1);
                this.stateConfigurationUrls = newUrls;
                this.stateRetryCount = 0;
                this.configurationReferenceDate = new Date();
                break;
            }
            case Fallback1: {
                if (!((double)(now.getTime() - this.configurationReferenceDate.getTime()) > 1.08E7)) break;
                this.state = BISConfigurationState.Fallback2;
                ArrayList<String> newUrls = new ArrayList<String>();
                newUrls.add("https://api.beaconsinspace.com/v1/secure/initialize?uam=1");
                newUrls.add(URL_configurationRetry1);
                newUrls.add(URL_configurationRetry2);
                this.stateConfigurationUrls = newUrls;
                this.stateRetryCount = 0;
                break;
            }
            case Fallback2: {
                if (!((double)(now.getTime() - this.configurationReferenceDate.getTime()) > 4.32E7)) break;
                this.state = BISConfigurationState.Fallback3;
                ArrayList<String> newUrls = new ArrayList<String>();
                newUrls.add("https://api.beaconsinspace.com/v1/secure/initialize?uam=1");
                newUrls.add(URL_configurationRetry1);
                newUrls.add(URL_configurationRetry2);
                newUrls.add(URL_configurationRetry3);
                this.stateConfigurationUrls = newUrls;
                this.stateRetryCount = 0;
                break;
            }
        }
        return 60000;
    }

    public boolean isModelSupportedForBluetoothUse() {
        String deviceModel = Build.MODEL;
        for (String unsupportedModel : BISConfiguration.getCurrentConfiguration().unsupportedAndroidModels) {
            if (!deviceModel.equals(unsupportedModel)) continue;
            BISLog.e(TAG, "BeaconsInSpace Detector Library does not run on Android Model " + unsupportedModel + " due to Networking/Bluetooth collision issues.");
            return false;
        }
        return true;
    }

    private static enum BISConfigurationState {
        Default,
        Provided,
        DefaultRetry,
        Fallback1,
        Fallback2,
        Fallback3;

    }
}

