/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.os.AsyncTask;
import com.beaconsinspace.android.beacon.detector.BISCollectionEvent;
import com.beaconsinspace.android.beacon.detector.BISLog;
import com.beaconsinspace.android.beacon.detector.BISNetworking;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.Identifier;

class BISNetworkingEventTask
extends AsyncTask<BISCollectionEvent, Integer, String> {
    private String apiUrl;
    private String bisData;

    public BISNetworkingEventTask(String apiUrl, String bisData) {
        this.apiUrl = apiUrl;
        this.bisData = bisData;
    }

    protected String doInBackground(BISCollectionEvent ... events) {
        if (events.length == 0) {
            return null;
        }
        String result = null;
        BISCollectionEvent event = events[0];
        String authorizationHeader = BISNetworking.getSharedManger().getAuthorizationHeader();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.putAll(BISNetworking.getSharedManger().getCommonRequestArguments());
        parameters.putAll(BISNetworking.getSharedManger().getLocationRequestArguments(event.location));
        parameters.putAll(this.getEventArguments(event));
        String data = BISNetworking.encodeParams(parameters);
        try {
            String line;
            HttpURLConnection urlConnection = (HttpURLConnection)new URL(this.apiUrl).openConnection();
            urlConnection.setDoOutput(true);
            urlConnection.setRequestProperty("Authorization", authorizationHeader);
            if (this.bisData != null) {
                urlConnection.setRequestProperty("bisData", this.bisData);
            }
            urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            urlConnection.setRequestProperty("Accept", "application/json");
            urlConnection.setRequestMethod("POST");
            urlConnection.connect();
            OutputStream outputStream = urlConnection.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            writer.write(data);
            writer.close();
            outputStream.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "UTF-8"));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            reader.close();
            result = sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            BISLog.e(((Object)((Object)this)).getClass().getName(), "UnsupportedEncodingException: " + e.getMessage());
        }
        catch (IOException e) {
            BISLog.e(((Object)((Object)this)).getClass().getName(), "IOException: " + e.getMessage());
        }
        catch (Exception e) {
            BISLog.e(((Object)((Object)this)).getClass().getName(), "Exception: " + e.getMessage());
        }
        return result;
    }

    private Map<String, String> getEventArguments(BISCollectionEvent event) {
        HashMap<String, String> request = new HashMap<String, String>();
        if (event != null) {
            request.put("detect", event.getDetect());
            request.put("eventType", event.getEventType());
            request.put("batteryLevel", Float.toString(event.batteryLevel));
            request.put("batteryState", event.batteryState);
            if (event.date != null) {
                request.put("creationTimeInEpochMillis", String.valueOf(event.date.getTime()));
            }
            String applicationState = "background";
            if (event.applicationState != null) {
                switch (event.applicationState) {
                    case ACTIVE: {
                        applicationState = "active";
                        break;
                    }
                    case INACTIVE: {
                        applicationState = "inactive";
                        break;
                    }
                    default: {
                        applicationState = "background";
                    }
                }
            }
            request.put("appStateDetection", applicationState);
            if (event.beacon != null) {
                String rssi;
                String[] identifiers = this.idsForBeacon(event.beacon);
                request.put("uuid", identifiers[0]);
                request.put("major", identifiers[1]);
                request.put("minor", identifiers[2]);
                if (event.eventDirection != null && event.eventDirection == BISCollectionEvent.BISCollectionEventDirection.Exit && (rssi = event.beaconRssiCollector.toJson()) != null) {
                    request.put("rssi", rssi);
                }
                if (event.location != null) {
                    double dateCreatedGeographicPosition = (double)event.location.getTime() / 1000.0;
                    request.put("dateCreatedGeographicPosition", Double.toString(dateCreatedGeographicPosition));
                }
            }
        }
        return request;
    }

    private String beaconIdentifierToString(Identifier i) {
        try {
            if (i == null) {
                return null;
            }
            String s = i.toString();
            if (s == null) {
                return null;
            }
            if (s.length() >= 2 && s.substring(0, 2).equals("0x")) {
                s = s.substring(2);
            }
            return s;
        }
        catch (Exception e) {
            BISLog.e(((Object)((Object)this)).getClass().getName(), "Exception: " + e.getMessage());
            return null;
        }
    }

    private String[] idsForBeacon(Beacon beacon) {
        if (beacon == null) {
            return new String[]{"", "", ""};
        }
        Identifier id1 = null;
        Identifier id2 = null;
        Identifier id3 = null;
        try {
            id1 = beacon.getIdentifiers().size() > 0 ? beacon.getId1() : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            id2 = beacon.getIdentifiers().size() > 1 ? beacon.getId2() : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            id3 = beacon.getIdentifiers().size() > 2 ? beacon.getId3() : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        String ID1 = id1 != null ? this.beaconIdentifierToString(id1) : "";
        String ID2 = id2 != null ? this.beaconIdentifierToString(id2) : "";
        String ID3 = id3 != null ? this.beaconIdentifierToString(id3) : "";
        return new String[]{ID1, ID2, ID3};
    }
}

