package com.beaconsinspace.android.beacon.detector;

import android.os.AsyncTask;
import android.util.Base64;
import android.util.Log;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * Created by kyleshank on 9/28/17.
 */

class BISNetworkingGetTask extends AsyncTask<String, String, String> {

    static private final String TAG = "BIS_NETWORK_REQUEST";
    static public final int STATUS_SUCCESS = 200;

    // reads an InputStream and converts it to a String
    private String readStream(InputStream stream) throws Exception {

        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        StringBuilder fullString = new StringBuilder();
        String line;

        while ((line = reader.readLine()) != null) {
            fullString.append(line);
        }

        return fullString.toString();
    }

    @Override
    protected String doInBackground(String... uri) {

        InputStream inputStream = null;
        String result = null;

        try
        {
            // prepare auth header
            String authorizationHeader = BISNetworking.getSharedManger().getAuthorizationHeader();
            URL url = new URL(uri[0]);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setRequestProperty( "Authorization", authorizationHeader );
            connection.setConnectTimeout(30000);
            connection.connect();

            int response = connection.getResponseCode();

            if(response == STATUS_SUCCESS)
            {
                inputStream = new BufferedInputStream(connection.getInputStream());
                result = readStream(inputStream);
            }
            else
            {
                Log.i(TAG, "STATUS_CODE is " + response);
            }
        }
        catch ( Exception e )
        {
            Log.e(TAG, "ERROR: " + e.getMessage());
        }
        finally
        {
            try
            {
                if(inputStream != null)
                {
                    inputStream.close();
                }
            }
            catch ( Exception e )
            {
                Log.e(TAG, "ERROR: " + e.getMessage());
            }
        }

        return result;
    }

    @Override
    protected void onPostExecute(String result) { super.onPostExecute(result); }
}