/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector.deviceatlas;

import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class FileUtil {
    private static final String TAG = FileUtil.class.getName();

    FileUtil() {
    }

    public static String loadFirstLine(String filePath) {
        List<String> lines = FileUtil.loadLines(filePath, true);
        if (lines != null && !lines.isEmpty()) {
            return lines.get(0);
        }
        return "";
    }

    public static List<String> loadLines(String filePath) {
        return FileUtil.loadLines(filePath, false);
    }

    public static String loadAsString(String filePath) {
        List<String> lines = FileUtil.loadLines(filePath, false);
        StringBuilder sb = new StringBuilder();
        for (String s : lines) {
            sb.append(s);
            sb.append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> loadLines(String filePath, boolean onlyFirstLine) {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(new File(filePath)));
            String line = null;
            while ((line = br.readLine()) != null) {
                lines.add(line.trim());
                if (!onlyFirstLine) continue;
                break;
            }
        }
        catch (IOException ex) {
            Log.d((String)TAG, (String)("Could not read file: " + filePath));
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
        return lines;
    }
}

