/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector.deviceatlas;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Rect;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.util.Log;
import com.beaconsinspace.android.beacon.detector.deviceatlas.Camera;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=21)
class CameraV2 {
    private static final String TAG = CameraV2.class.getName();

    CameraV2() {
    }

    public static List<Camera> getCameras(Context context) {
        ArrayList<Camera> toReturn = new ArrayList<Camera>();
        CameraManager manager = (CameraManager)context.getSystemService("camera");
        try {
            String[] cameras;
            for (String cameraId : cameras = manager.getCameraIdList()) {
                CameraCharacteristics chara = manager.getCameraCharacteristics(cameraId);
                boolean hasFlash = (Boolean)chara.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
                Rect pixelRect = (Rect)chara.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
                toReturn.add(new Camera(pixelRect.width(), pixelRect.height(), CameraV2.getFacing(chara), hasFlash));
            }
        }
        catch (CameraAccessException | SecurityException e) {
            Log.d((String)TAG, (String)e.toString());
        }
        return toReturn;
    }

    private static String getFacing(CameraCharacteristics chara) {
        Integer facing = (Integer)chara.get(CameraCharacteristics.LENS_FACING);
        switch (facing) {
            case 0: {
                return "front";
            }
            case 1: {
                return "back";
            }
            case 2: {
                return "external";
            }
        }
        return "id=" + facing;
    }
}

