/*
 * Copyright (c) Afilias Technologies Ltd 2017. All rights reserved.
 */


package com.beaconsinspace.android.beacon.detector.deviceatlas;

import org.json.JSONException;
import org.json.JSONObject;

import javax.microedition.khronos.opengles.GL10;

/**
 * @author Afilias Technologies Ltd
 */
class GpuProperties implements Properties {
    private static final String TAG = GpuProperties.class.getName();

    public static final String VENDOR = "vendor";
    public static final String RENDERER = "renderer";
    // private static final String GL_MAX_VERSION = "glMaxVersion"; // TODO

    private final String vendor;
    private final String renderer;

    /**
     * Load GPU properties. Note this must be called after the GPU renderer has been initialised.
     */
    public GpuProperties(GL10 gl) {
        vendor = gl.glGetString(GL10.GL_VENDOR);
        renderer = gl.glGetString(GL10.GL_RENDERER);
    }


    @Override
    public JSONObject getProperties() throws JSONException {
        JSONObject props = new JSONObject();
        props.put(VENDOR, vendor);
        props.put(RENDERER, renderer);

        return props;
    }
}
