/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector.deviceatlas;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.os.Build;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class SensorProperties {
    SensorProperties() {
    }

    public static JSONArray getProperties(Context context) throws JSONException {
        JSONArray props = new JSONArray();
        SensorManager mgr = (SensorManager)context.getSystemService("sensor");
        List sensors = mgr.getSensorList(-1);
        for (Sensor sensor : sensors) {
            JSONObject s = new JSONObject();
            s.put("name", (Object)sensor.getName());
            s.put("vendor", (Object)sensor.getVendor());
            s.put("maxRange", (double)sensor.getMaximumRange());
            s.put("powerMa", (double)sensor.getPower());
            s.put("resolution", (double)sensor.getResolution());
            s.put("version", sensor.getVersion());
            if (Build.VERSION.SDK_INT >= 9) {
                s.put("minDelayUs", sensor.getMinDelay());
            }
            String type = Build.VERSION.SDK_INT >= 20 ? SensorProperties.cleanType(sensor.getStringType()) : SensorProperties.getTypeFromId(sensor.getType());
            s.put("type", (Object)type);
            if (Build.VERSION.SDK_INT >= 21) {
                s.put("isWakeUpSensor", sensor.isWakeUpSensor());
                s.put("maxDelayUs", sensor.getMaxDelay());
                s.put("reportingMode", (Object)SensorProperties.getReportingMode(sensor.getReportingMode()));
            }
            props.put((Object)s);
        }
        return props;
    }

    private static String getReportingMode(int mode) {
        switch (mode) {
            case 0: {
                return "continuous";
            }
            case 1: {
                return "on_change";
            }
            case 2: {
                return "one_shot";
            }
            case 3: {
                return "special_trigger";
            }
        }
        return "id=" + mode;
    }

    private static String cleanType(String type) {
        String prefix = "android.sensor.";
        if (type.startsWith(prefix)) {
            type = type.substring(prefix.length());
        }
        return type;
    }

    private static String getTypeFromId(int type) {
        switch (type) {
            case 1: {
                return "accelerometer";
            }
            case 13: {
                return "ambient_temperature";
            }
            case 15: {
                return "game_rotation_vector";
            }
            case 20: {
                return "geomagnetic_rotation_vector";
            }
            case 9: {
                return "gravity";
            }
            case 4: {
                return "gyroscope";
            }
            case 16: {
                return "gyroscope_uncalibrated";
            }
            case 31: {
                return "heart_beat";
            }
            case 21: {
                return "heart_rate";
            }
            case 5: {
                return "light";
            }
            case 10: {
                return "linear_acceleration";
            }
            case 2: {
                return "magnetic_field";
            }
            case 14: {
                return "magnetic_field_uncalibrated";
            }
            case 30: {
                return "motion_detect";
            }
            case 3: {
                return "orientation";
            }
            case 28: {
                return "pose_6dof";
            }
            case 6: {
                return "pressure";
            }
            case 8: {
                return "proximity";
            }
            case 12: {
                return "relative_humidity";
            }
            case 11: {
                return "rotation_vector";
            }
            case 17: {
                return "significant_motion";
            }
            case 29: {
                return "stationary_detect";
            }
            case 19: {
                return "step_counter";
            }
            case 18: {
                return "step_detector";
            }
            case 7: {
                return "temperature";
            }
        }
        return "id=" + type;
    }
}

