/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector.DeviceAtlas;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import com.beaconsinspace.android.beacon.detector.DeviceAtlas.CpuProperties;
import com.beaconsinspace.android.beacon.detector.DeviceAtlas.DisplayProperties;
import com.beaconsinspace.android.beacon.detector.DeviceAtlas.GpuCallback;
import com.beaconsinspace.android.beacon.detector.DeviceAtlas.GpuLoader;
import com.beaconsinspace.android.beacon.detector.DeviceAtlas.GpuProperties;
import com.beaconsinspace.android.beacon.detector.DeviceAtlas.HandleDataCallback;
import com.beaconsinspace.android.beacon.detector.DeviceAtlas.MemoryProperties;
import com.beaconsinspace.android.beacon.detector.DeviceAtlas.SensorProperties;
import com.beaconsinspace.android.beacon.detector.DeviceAtlas.StorageProperties;
import com.beaconsinspace.android.beacon.detector.DeviceAtlas.StrUtil;
import com.beaconsinspace.android.beacon.detector.DeviceAtlas.TelephonyProperties;
import com.beaconsinspace.android.beacon.detector.DeviceAtlas.WebProperties;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class DataCollector
extends GpuCallback {
    private static final String TAG = DataCollector.class.getName();
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
    public static final String INFO = "info";
    private static final String VERSION = "version";
    private static final String SOURCE = "source";
    private static final String VERSION_NUM = "0.1";
    private static final String DATE = "date";
    public static final String DATA = "data";
    private static final String BUILD = "build";
    private static final String BUILD_VERSION = "buildVersion";
    private static final String WEB = "web";
    private static final String CPU = "cpu";
    private static final String MEMORY = "memory";
    private static final String GPU = "gpu";
    private static final String TELEPHONY = "telephony";
    private static final String STORAGE = "storage";
    private static final String SENSORS = "sensors";
    private static final String DISPLAY = "display";
    private static final String BATTERY = "battery";
    private static final String KEYBOARD = "keyboard";
    private static final String CAMERA = "camera";
    private Activity appContext;
    private HandleDataCallback callback;

    public DataCollector(Activity activity) {
        this(activity, null);
    }

    public DataCollector(Activity activity, HandleDataCallback callback) {
        Log.i((String)TAG, (String)"DataCollector");
        this.appContext = activity;
        this.callback = callback;
        GpuLoader gpuLoader = new GpuLoader();
        gpuLoader.load(activity, this);
    }

    @Override
    protected void collectStats(GpuProperties gpuProps) {
        try {
            JSONObject data = new JSONObject();
            data.put(BUILD, (Object)this.getBuildProperties());
            data.put(BUILD_VERSION, (Object)this.getBuildVersionProperties());
            data.put(WEB, (Object)WebProperties.getProperties((Context)this.appContext));
            data.put(CPU, (Object)CpuProperties.getProperties());
            data.put(GPU, (Object)gpuProps.getProperties());
            data.put(MEMORY, (Object)MemoryProperties.getProperties());
            data.put(DISPLAY, (Object)DisplayProperties.getProperties((Context)this.appContext));
            data.put(TELEPHONY, (Object)TelephonyProperties.getProperties((Context)this.appContext));
            data.put(STORAGE, (Object)StorageProperties.getProperties());
            data.put(SENSORS, (Object)SensorProperties.getProperties((Context)this.appContext));
            JSONObject all = new JSONObject();
            all.put(INFO, (Object)this.getInfo());
            all.put(DATA, (Object)data);
            if (this.callback != null) {
                this.callback.handleData(all);
            }
        }
        catch (Throwable ex) {
            Log.d((String)TAG, (String)ex.toString());
        }
    }

    private JSONObject getInfo() throws JSONException {
        JSONObject info = new JSONObject();
        info.put(VERSION, (Object)VERSION_NUM);
        info.put(DATE, (Object)DATE_FORMAT.format(new Date()));
        info.put(SOURCE, (Object)this.getAppName());
        return info;
    }

    private String getAppName() {
        return this.appContext.getApplicationInfo().loadLabel(this.appContext.getPackageManager()).toString();
    }

    private JSONObject getBuildProperties() throws JSONException {
        Field[] fields = Build.class.getDeclaredFields();
        return this.getPropertiesFromFields(fields, null);
    }

    private JSONObject getBuildVersionProperties() throws JSONException {
        Field[] fields = Build.VERSION.class.getDeclaredFields();
        HashSet<String> exclude = new HashSet<String>();
        exclude.add("SDK");
        return this.getPropertiesFromFields(fields, exclude);
    }

    private JSONObject getPropertiesFromFields(Field[] fields, Set<String> exclude) throws JSONException {
        JSONObject props = new JSONObject();
        for (Field field : fields) {
            String key = field.getName();
            if (exclude != null && exclude.contains(key)) continue;
            try {
                key = StrUtil.toCamelCase(field.getName());
                String value = StrUtil.asString(field.get(key));
                props.put(key, (Object)value);
            }
            catch (IllegalAccessException e) {
                Log.d((String)TAG, (String)("*** Can't access: " + key));
            }
        }
        return props;
    }

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

