/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.util.Log;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

class BISShellAccess {
    private static final String TAG = "BISShellAccess";

    BISShellAccess() {
    }

    public static Process exec(String cmd) {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(cmd);
            if (process == null) {
                return null;
            }
            process.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return process;
    }

    public static String executeCommandAndGetSpecificLine(String cmd, String prefix, boolean replace) {
        try {
            Process process = BISShellAccess.exec(cmd);
            if (process != null) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    if (!line.startsWith(prefix)) continue;
                    if (replace) {
                        return line.replace(prefix, "");
                    }
                    return line;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String executeCommandAndGetAllLines(String cmd) {
        String result = "";
        Process process = BISShellAccess.exec(cmd);
        if (process != null) {
            try {
                result = BISShellAccess.readFully(process.getInputStream());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            BISShellAccess.endProcess(process);
        }
        return result;
    }

    public static String executeCommandAndGetFirstLine(String cmd) {
        String result = "";
        Process process = BISShellAccess.exec(cmd);
        if (process != null) {
            result = BISShellAccess.readFirstLine(process.getInputStream());
            BISShellAccess.endProcess(process);
        }
        return result;
    }

    public static String readFully(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = is.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        return baos.toString("UTF-8");
    }

    public static String readFirstLine(InputStream is) {
        String result = null;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            result = reader.readLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    static String getAllRunningProcessNames() {
        Process process = null;
        String result = null;
        try {
            String line;
            process = Runtime.getRuntime().exec("/system/bin/ls /proc");
            if (process == null) {
                return result;
            }
            process.waitFor();
            String processLine = "";
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                try {
                    int processId = Integer.parseInt(line);
                    Process p = Runtime.getRuntime().exec("/system/bin/cat /proc/" + line + "/status");
                    String nameLine = BISShellAccess.readFirstLine(p.getInputStream());
                    if (nameLine == null) continue;
                    nameLine = nameLine.replace("Name:\t", "");
                    processLine = processLine + nameLine + "|";
                    Log.i((String)TAG, (String)nameLine);
                }
                catch (Exception exception) {}
            }
            result = processLine;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static void endProcess(Process process) {
        process.destroy();
    }
}

