/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector.deviceatlas;

import android.util.Log;
import com.beaconsinspace.android.beacon.detector.deviceatlas.FileUtil;
import com.beaconsinspace.android.beacon.detector.deviceatlas.StrUtil;
import java.io.File;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

class CpuProperties {
    private static final String TAG = CpuProperties.class.getName();
    private static final String AVAILABLE_PROCESSORS = "availableProcessors";
    private static final String NUM_CORES = "numCores";
    private static final String CPU_INFO = "cpuInfo";
    private static final String CPU_MIN_FREQ_KHZ = "cpuMinFreqKhz";
    private static final String CPU_MAX_FREQ_KHZ = "cpuMaxFreqKhz";
    private static final String ARCH = "arch";

    CpuProperties() {
    }

    public static JSONObject getProperties() throws JSONException {
        JSONObject props = new JSONObject();
        props.put(AVAILABLE_PROCESSORS, Runtime.getRuntime().availableProcessors());
        props.put(NUM_CORES, CpuProperties.getNumCores());
        props.put(CPU_INFO, (Object)FileUtil.loadAsString("/proc/cpuinfo"));
        props.put(CPU_MIN_FREQ_KHZ, (Object)FileUtil.loadFirstLine("/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq"));
        props.put(CPU_MAX_FREQ_KHZ, (Object)FileUtil.loadFirstLine("/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq"));
        props.put(ARCH, (Object)StrUtil.asString(System.getProperty("os.arch")));
        return props;
    }

    private static int getNumCores() {
        int count = 0;
        File dir = new File("/sys/devices/system/cpu/");
        try {
            String[] files = dir.list();
            if (files != null) {
                for (String name : files) {
                    if (!Pattern.matches("cpu[0-9]+", name)) continue;
                    ++count;
                }
            }
        }
        catch (SecurityException ex) {
            Log.d((String)TAG, (String)("Could not access dir " + dir.toString()));
        }
        return count;
    }
}

