/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.content.Context;
import android.support.annotation.VisibleForTesting;
import com.beaconsinspace.android.beacon.detector.BISException;
import com.beaconsinspace.android.beacon.detector.BISLog;
import com.beaconsinspace.android.beacon.detector.fgchecker.AppChecker;
import com.beaconsinspace.android.beacon.detector.fgchecker.Utils;
import com.beaconsinspace.android.beacon.detector.processes.AndroidProcesses;
import com.beaconsinspace.android.beacon.detector.processes.models.AndroidAppProcess;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BISProcessManager {
    private static final String TAG = "BISProcessManager";
    private static final String BIS_INTERNAL_STORAGE_DIR = "beaconsinspace";
    private static final String FILE_PROCESSES_DATA = "processes.json";
    private static BISProcessManager sInstance;
    private Context appContext;
    private File mBeaconsDir;
    private File mProcessesFile;
    @JsonProperty
    HashMap<String, BISAppProcess> mBISAppProcesses = new HashMap();
    AppChecker mAppChecker = new AppChecker();
    Set<String> currentAppProcesses = new HashSet<String>();
    Set<String> oldAppProcesses = new HashSet<String>();
    private String mForeGroundApp = "";

    private BISProcessManager(Context context) {
        this.appContext = context.getApplicationContext();
        this.createProcessesFile();
    }

    public static BISProcessManager createInstance(Context context) {
        if (sInstance == null) {
            sInstance = new BISProcessManager(context);
        }
        return sInstance;
    }

    public static BISProcessManager getInstance() {
        if (sInstance == null) {
            try {
                throw new BISException("Create a BISProcessManager instance first.");
            }
            catch (BISException bISException) {
                // empty catch block
            }
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scanRunningAppProcesses() {
        HashMap<String, BISAppProcess> hashMap = this.mBISAppProcesses;
        synchronized (hashMap) {
            BISAppProcess bisAppProcess;
            this.loadBISAppProcessFromProcessesFile();
            if (Utils.postLollipop()) {
                if (Utils.hasUsageStatsPermission(this.appContext)) {
                    this.scanForegroundProcess();
                }
            } else {
                this.scanForegroundProcess();
            }
            BISProcessManager.sInstance.oldAppProcesses = new HashSet<String>(BISProcessManager.sInstance.currentAppProcesses);
            ArrayList activeProcesses = (ArrayList)AndroidProcesses.getRunningAppProcesses();
            BISProcessManager.sInstance.currentAppProcesses.clear();
            for (Object appProcess : activeProcesses) {
                BISProcessManager.sInstance.currentAppProcesses.add(((AndroidAppProcess)appProcess).getPackageName());
            }
            HashSet<String> closedProcesses = new HashSet<String>();
            for (String packageName : BISProcessManager.sInstance.oldAppProcesses) {
                if (BISProcessManager.sInstance.currentAppProcesses.contains(packageName)) continue;
                closedProcesses.add(packageName);
            }
            HashSet<String> newProcesses = new HashSet<String>();
            for (String packageName : BISProcessManager.sInstance.currentAppProcesses) {
                if (BISProcessManager.sInstance.oldAppProcesses.contains(packageName)) continue;
                newProcesses.add(packageName);
            }
            for (String processName : newProcesses) {
                if (this.mBISAppProcesses.containsKey(processName)) {
                    bisAppProcess = this.mBISAppProcesses.get(processName);
                    bisAppProcess.r.add(new BISAppProcess.ProcTimeStamp(BISProcessManager.millisToBISFormat(System.currentTimeMillis()), "-1"));
                    this.mBISAppProcesses.put(processName, bisAppProcess);
                    continue;
                }
                bisAppProcess = new BISAppProcess();
                bisAppProcess.r.add(new BISAppProcess.ProcTimeStamp(BISProcessManager.millisToBISFormat(System.currentTimeMillis()), "-1"));
                this.mBISAppProcesses.put(processName, bisAppProcess);
            }
            for (String processName : closedProcesses) {
                if (this.mBISAppProcesses.containsKey(processName)) {
                    bisAppProcess = this.mBISAppProcesses.get(processName);
                    int lastElement = bisAppProcess.r.size() - 1;
                    this.mBISAppProcesses.get((Object)processName).r.get((int)lastElement).e = BISProcessManager.millisToBISFormat(System.currentTimeMillis());
                    continue;
                }
                bisAppProcess = new BISAppProcess();
                bisAppProcess.r.add(new BISAppProcess.ProcTimeStamp("-1", BISProcessManager.millisToBISFormat(System.currentTimeMillis())));
                this.mBISAppProcesses.put(processName, bisAppProcess);
            }
            this.writeProcessesToFile(this.convertObjectToJson(this.mBISAppProcesses));
        }
    }

    private void scanForegroundProcess() {
        String processName = this.mAppChecker.getForegroundApp(this.appContext);
        if (!this.mForeGroundApp.equalsIgnoreCase(processName)) {
            BISAppProcess appProcess = this.mBISAppProcesses.get(this.mForeGroundApp);
            try {
                int lastProcTimestamp = appProcess.f.size() - 1;
                appProcess.f.get((int)lastProcTimestamp).e = BISProcessManager.millisToBISFormat(System.currentTimeMillis());
                this.mBISAppProcesses.put(this.mForeGroundApp, appProcess);
            }
            catch (Exception lastProcTimestamp) {
                // empty catch block
            }
            if (this.mBISAppProcesses.containsKey(processName)) {
                BISAppProcess bisAppProcess = this.mBISAppProcesses.get(processName);
                bisAppProcess.f.add(new BISAppProcess.ProcTimeStamp(BISProcessManager.millisToBISFormat(System.currentTimeMillis()), "-1"));
                this.mBISAppProcesses.put(processName, bisAppProcess);
            } else {
                BISAppProcess bisAppProcess = new BISAppProcess();
                bisAppProcess.f.add(new BISAppProcess.ProcTimeStamp(BISProcessManager.millisToBISFormat(System.currentTimeMillis()), "-1"));
                this.mBISAppProcesses.put(processName, bisAppProcess);
            }
        }
        this.mForeGroundApp = processName;
    }

    private void createProcessesFile() {
        this.mBeaconsDir = this.appContext.getDir(BIS_INTERNAL_STORAGE_DIR, 0);
        this.mProcessesFile = new File(this.mBeaconsDir, FILE_PROCESSES_DATA);
        try {
            FileOutputStream outputStream = new FileOutputStream(this.mProcessesFile);
            outputStream.write("{}".getBytes());
            outputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            BISLog.wtf(TAG, "Error creating OutputStream for processes.json", fileNotFoundException);
        }
        catch (IOException ioException) {
            BISLog.wtf(TAG, "Error writing to processes.json", ioException);
        }
    }

    private void loadBISAppProcessFromProcessesFile() {
        String jsonString = this.getJsonFromProcFile();
        this.loadProcessesFromJsonString(jsonString);
    }

    private void writeProcessesToFile(String json) {
        if (json != null) {
            try {
                FileOutputStream outputStream = new FileOutputStream(this.mProcessesFile, false);
                ((OutputStream)outputStream).write(json.getBytes());
                outputStream.flush();
                ((OutputStream)outputStream).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                BISLog.e(TAG, "ProcessesFile not found while writing processes data", fileNotFoundException);
            }
            catch (IOException ioException) {
                BISLog.e(TAG, "Error while writing to processes.json", ioException);
            }
        }
    }

    private void loadProcessesFromJsonString(String json) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = null;
        try {
            rootNode = mapper.readTree(json);
        }
        catch (IOException ioException) {
            System.out.println("Error reading Json string" + ioException.getMessage());
            return;
        }
        Iterator procIterator = rootNode.fields();
        while (procIterator.hasNext()) {
            JsonNode f_procTimeStampsArray;
            Map.Entry field = (Map.Entry)procIterator.next();
            String processName = (String)field.getKey();
            BISAppProcess bisAppProcess = new BISAppProcess();
            JsonNode procData = (JsonNode)field.getValue();
            JsonNode r_procTimeStampsArray = procData.get("r");
            if (r_procTimeStampsArray != null) {
                String jsonArray = r_procTimeStampsArray.toString();
                if (r_procTimeStampsArray.isArray()) {
                    try {
                        ObjectMapper r_ObjectMapper = new ObjectMapper();
                        CollectionType collectionType = r_ObjectMapper.getTypeFactory().constructCollectionType(ArrayList.class, BISAppProcess.ProcTimeStamp.class);
                        bisAppProcess.r = (ArrayList)r_ObjectMapper.readValue(jsonArray, (JavaType)collectionType);
                    }
                    catch (IOException ioException) {
                        BISLog.e(TAG, "Error reading 'r' jsonArray of BISAppProcess", ioException);
                    }
                }
            }
            if ((f_procTimeStampsArray = procData.get("f")) != null) {
                String jsonArray = f_procTimeStampsArray.toString();
                if (f_procTimeStampsArray.isArray()) {
                    try {
                        ObjectMapper f_ObjectMapper = new ObjectMapper();
                        CollectionType collectionType = f_ObjectMapper.getTypeFactory().constructCollectionType(ArrayList.class, BISAppProcess.ProcTimeStamp.class);
                        bisAppProcess.f = (ArrayList)f_ObjectMapper.readValue(jsonArray, (JavaType)collectionType);
                    }
                    catch (IOException ioException) {
                        BISLog.e(TAG, "Error reading 'f' jsonArray of BISAppProcess", ioException);
                    }
                }
            }
            this.mBISAppProcesses.put(processName, bisAppProcess);
        }
    }

    public String getJsonFromProcFile() {
        String jsonString = null;
        try {
            FileInputStream is = new FileInputStream(this.mProcessesFile);
            BufferedReader buf = new BufferedReader(new InputStreamReader(is));
            String line = buf.readLine();
            StringBuilder sb = new StringBuilder();
            while (line != null) {
                sb.append(line);
                line = buf.readLine();
            }
            jsonString = sb.toString();
        }
        catch (IOException ioException) {
            BISLog.e(TAG, "Error occurred while reading from bufferedreader", ioException);
        }
        return jsonString;
    }

    private String convertObjectToJson(Object object) {
        String jsonString = null;
        ObjectWriter objectWriter = new ObjectMapper().writer();
        try {
            jsonString = objectWriter.writeValueAsString(object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            jsonProcessingException.printStackTrace();
        }
        return jsonString;
    }

    public static String millisToBISFormat(long time) {
        long seconds = time / 1000L;
        long milli = time % 1000L;
        String millistr = milli < 10L ? "00" + String.valueOf(milli) : (milli < 100L ? "0" + String.valueOf(milli) : String.valueOf(milli));
        String formattedTime = String.valueOf(seconds) + "." + millistr;
        return formattedTime;
    }

    public long getProcFileSize() {
        return this.mProcessesFile.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        HashMap<String, BISAppProcess> hashMap = this.mBISAppProcesses;
        synchronized (hashMap) {
            this.writeProcessesToFile("{}");
            this.mBISAppProcesses = new HashMap();
        }
    }

    @VisibleForTesting
    void __writeToFile(String string) {
        File file = new File(this.mBeaconsDir, "restCall_" + System.currentTimeMillis() + ".txt");
        try {
            FileOutputStream outputStream = new FileOutputStream(file);
            ((OutputStream)outputStream).write(string.getBytes());
            outputStream.flush();
            ((OutputStream)outputStream).close();
        }
        catch (FileNotFoundException e) {
            BISLog.e(TAG, "restCall.txt not found", e);
        }
        catch (IOException e) {
            BISLog.e(TAG, "Error writing to restCall.txt", e);
        }
    }

    static class BISAppProcess {
        @JsonProperty
        ArrayList<ProcTimeStamp> r = new ArrayList();
        @JsonProperty
        ArrayList<ProcTimeStamp> f = new ArrayList();

        BISAppProcess() {
        }

        static class ProcTimeStamp {
            @JsonProperty
            String b = "-1";
            @JsonProperty
            String e = "-1";

            public ProcTimeStamp() {
            }

            public ProcTimeStamp(String b, String e) {
                this.b = b;
                this.e = e;
            }
        }
    }
}

