package com.beaconsinspace.android.beacon.detector.deviceatlas;

import android.content.Context;
import android.os.Build;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;


/**
 * @author Afilias Technologies Ltd
 */
class CameraProperties {
    private static final String TAG = CameraProperties.class.getName();
    protected static final String FACING_FRONT = "front";
    protected static final String FACING_BACK = "back";
    protected static final String FACING_EXTERNAL = "external";
    protected static final String WIDTH_PIXELS = "widthPixels";
    protected static final String HEIGHT_PIXELS = "heightPixels";
    protected static final String MEGA_PIXELS = "megaPixels";
    protected static final String FACING = "facing";
    protected static final String HAS_FLASH = "hasFlash";


    public static JSONArray getProperties(Context context) throws JSONException {
        List<Camera> cameras = new ArrayList<>();

        // ideally we use Camera2 as it does not need camera access permissions to get the properties
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            cameras = CameraV2.getCameras(context);

        } else if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.GINGERBREAD) {
            cameras = CameraV1.getCameras();
        }

        JSONArray toReturn = new JSONArray();
        for(Camera cam : cameras) {
            JSONObject props = new JSONObject();
            props.put(WIDTH_PIXELS, cam.widthPixels);
            props.put(HEIGHT_PIXELS, cam.heightPixels);
            props.put(MEGA_PIXELS, cam.megaPixels);
            props.put(FACING, cam.facing);
            props.put(HAS_FLASH, cam.hasFlash);

            toReturn.put(props);
        }

        return toReturn;
    }

}
