/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector.DeviceAtlas;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.webkit.WebSettings;
import android.webkit.WebView;
import java.lang.reflect.Constructor;
import org.json.JSONException;
import org.json.JSONObject;

class WebProperties {
    private static final String SYSTEM_USER_AGENT = "systemUserAgent";
    private static final String WEBVIEW_USER_AGENT = "webviewUserAgent";

    WebProperties() {
    }

    public static JSONObject getProperties(Context context) throws JSONException {
        JSONObject props = new JSONObject();
        props.put(SYSTEM_USER_AGENT, (Object)System.getProperty("http.agent"));
        props.put(WEBVIEW_USER_AGENT, (Object)WebProperties.getWebviewUserAgentString(context));
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getWebviewUserAgentString(Context context) {
        if (Build.VERSION.SDK_INT >= 17) {
            return NewApiWrapper.getDefaultUserAgent(context);
        }
        Constructor constructor = WebSettings.class.getDeclaredConstructor(Context.class, WebView.class);
        constructor.setAccessible(true);
        try {
            WebSettings settings = (WebSettings)constructor.newInstance(context, null);
            String string = settings.getUserAgentString();
            constructor.setAccessible(false);
            return string;
        }
        catch (Throwable throwable) {
            try {
                constructor.setAccessible(false);
                throw throwable;
            }
            catch (Exception e) {
                WebView webView = new WebView(context);
                return webView.getSettings().getUserAgentString();
            }
        }
    }

    @TargetApi(value=17)
    static class NewApiWrapper {
        NewApiWrapper() {
        }

        static String getDefaultUserAgent(Context context) {
            return WebSettings.getDefaultUserAgent((Context)context);
        }
    }
}

