/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector.DeviceAtlas;

import android.content.Context;
import android.os.Build;
import android.telephony.TelephonyManager;
import org.json.JSONException;
import org.json.JSONObject;

public class TelephonyProperties {
    private static final String MMS_UA_PROF_URL = "mmsUaProfUrl";
    private static final String MMS_UA = "mmsUa";
    private static final String PHONE_TYPE = "phoneType";
    private static final String NETWORK_MCC_MNC = "networkMccMnc";
    private static final String NETWORK_OPERATOR = "networkOperator";
    private static final String NETWORK_COUNTRY_ISO = "networkCountryIso";
    private static final String SIM_MCC_MNC = "simMccMnc";
    private static final String SIM_OPERATOR = "simOperator";
    private static final String SIM_COUNTRY_ISO = "simCountryIso";
    private static final String PHONE_COUNT = "phoneCount";
    private static final String IS_ROAMING = "isRoaming";
    private static final String IS_VOICE_CAPABLE = "isVoiceCapable";
    private static final String IS_WORLD_PHONE = "isWorldPhone";
    private static final String IS_HEARING_AID_COMPATIBLE = "isHearingAidCompatibilitySupported";
    private static final String IS_TTY_MODE_SUPPORTED = "isTtyModeSupported";
    private static final String TAC = "tac";

    public static JSONObject getProperties(Context context) throws JSONException {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        JSONObject props = new JSONObject();
        props.put(IS_ROAMING, tm.isNetworkRoaming());
        props.put(PHONE_TYPE, (Object)TelephonyProperties.getPhoneType(tm));
        props.put(NETWORK_MCC_MNC, (Object)tm.getNetworkOperator());
        props.put(NETWORK_OPERATOR, (Object)tm.getNetworkOperatorName());
        props.put(NETWORK_COUNTRY_ISO, (Object)tm.getNetworkCountryIso());
        if (tm.getSimState() == 5) {
            props.put(SIM_MCC_MNC, (Object)tm.getSimOperator());
            props.put(SIM_OPERATOR, (Object)tm.getSimOperatorName());
            props.put(SIM_COUNTRY_ISO, (Object)tm.getSimCountryIso());
        }
        if (Build.VERSION.SDK_INT >= 19) {
            props.put(MMS_UA_PROF_URL, (Object)tm.getMmsUAProfUrl());
            props.put(MMS_UA, (Object)tm.getMmsUserAgent());
        }
        if (Build.VERSION.SDK_INT >= 22) {
            props.put(IS_VOICE_CAPABLE, tm.isVoiceCapable());
        }
        if (Build.VERSION.SDK_INT >= 23) {
            props.put(PHONE_COUNT, tm.getPhoneCount());
            props.put(IS_HEARING_AID_COMPATIBLE, tm.isHearingAidCompatibilitySupported());
            props.put(IS_TTY_MODE_SUPPORTED, tm.isTtyModeSupported());
        }
        if (Build.VERSION.SDK_INT < 23) {
            props.put(TAC, (Object)TelephonyProperties.getTac(tm));
        }
        return props;
    }

    private static String getPhoneType(TelephonyManager tm) {
        int type = tm.getPhoneType();
        switch (type) {
            case 1: {
                return "gsm";
            }
            case 2: {
                return "cdma";
            }
            case 3: {
                return "sip";
            }
            case 0: {
                return "none";
            }
        }
        return "id=" + type;
    }

    private static String getTac(TelephonyManager tm) {
        String tac = "";
        if (tm.getPhoneType() == 1) {
            try {
                String deviceId = tm.getDeviceId();
                if (deviceId != null && deviceId.length() > 8) {
                    tac = deviceId.substring(0, 8);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return tac;
    }
}

