/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector.DeviceAtlas;

import android.util.Log;
import com.beaconsinspace.android.beacon.detector.DeviceAtlas.FileUtil;
import com.beaconsinspace.android.beacon.detector.DeviceAtlas.StrUtil;
import java.io.File;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

class CpuProperties {
    private static final String TAG = CpuProperties.class.getName();

    CpuProperties() {
    }

    public static JSONObject getProperties() throws JSONException {
        JSONObject props = new JSONObject();
        props.put("availableProcessors", Runtime.getRuntime().availableProcessors());
        props.put("numCores", CpuProperties.getNumCores());
        props.put("cpuInfo", (Object)FileUtil.loadAsString("/proc/cpuinfo"));
        props.put("cpuMinFreqKhz", (Object)FileUtil.loadFirstLine("/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq"));
        props.put("cpuMaxFreqKhz", (Object)FileUtil.loadFirstLine("/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq"));
        props.put("arch", (Object)StrUtil.asString(System.getProperty("os.arch")));
        return props;
    }

    private static int getNumCores() {
        int count = 0;
        File dir = new File("/sys/devices/system/cpu/");
        try {
            String[] files = dir.list();
            if (files != null) {
                for (String name : files) {
                    if (!Pattern.matches("cpu[0-9]+", name)) continue;
                    ++count;
                }
            }
        }
        catch (SecurityException ex) {
            Log.d((String)TAG, (String)("Could not access dir " + dir.toString()));
        }
        return count;
    }
}

