/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.location.Location;
import android.os.Build;
import android.util.Base64;
import android.util.Log;
import com.beaconsinspace.android.beacon.detector.BISDetector;
import com.beaconsinspace.android.beacon.detector.BISDetectorAsyncRequest;
import com.beaconsinspace.android.beacon.detector.BISDetectorInternalDelegate;
import com.beaconsinspace.android.beacon.detector.BISDetectorManager;
import com.beaconsinspace.android.beacon.detector.BISLocationListener;
import com.beaconsinspace.android.beacon.detector.BISPersistentStorage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import org.altbeacon.beacon.Beacon;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class BISDetectorREST {
    static final String TAG = "BIS_REST";
    static final String BIS_BASE_URL = "https://api.beaconsinspace.com";
    static final String BIS_URL_EVENT = "https://api.beaconsinspace.com/v1/event";
    static final String BIS_URL_BEACON = "https://api.beaconsinspace.com/v1/beacon";
    static final String BIS_URL_INITIALIZE = "https://api.beaconsinspace.com/v1/secure/initialize?uam=1";
    static BISDetectorInternalDelegate delegate;

    BISDetectorREST() {
    }

    public static void setDelegate(BISDetectorInternalDelegate _delegate) {
        delegate = _delegate;
    }

    public static ArrayList<String> getBeaconsInfoFromServer() {
        Log.i((String)TAG, (String)"Getting beacon identifiers from BeaconsInSpace API");
        String responseString = BISDetectorREST.getBeaconsList();
        if (responseString == null || responseString.length() == 0) {
            BISDetector.sharedInstance.onBeaconsInfoReceiveFail(503, null);
            return null;
        }
        ArrayList<String> uuids = new ArrayList<String>();
        try {
            JSONObject jsonObject = new JSONObject(responseString);
            int responseCode = jsonObject.getInt("code");
            if (responseCode != 200) {
                BISDetector.sharedInstance.onBeaconsInfoReceiveFail(responseCode, null);
                return null;
            }
            JSONArray jsonArrayData = jsonObject.getJSONArray("data");
            if (jsonArrayData == null) {
                return null;
            }
            for (int i = 0; i < jsonArrayData.length(); ++i) {
                String uuid;
                JSONObject jsonObjectBeacon = jsonArrayData.getJSONObject(i);
                String protocol = jsonObjectBeacon.getString("protocol");
                if (!protocol.equalsIgnoreCase("ibeacon") || (uuid = jsonObjectBeacon.getString("uuid")) == null) continue;
                uuids.add(uuid);
            }
            if (uuids.size() > 0) {
                BISDetector.beaconsManager().updateUUIDs(uuids);
                if (delegate != null) {
                    delegate.onBeaconsInfoReceiveSuccess();
                }
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("JSONException: " + e.getMessage()));
            BISDetector.sharedInstance.onBeaconsInfoReceiveFail(503, null);
        }
        return uuids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getBeaconsList() {
        String urlToCall = "https://api.beaconsinspace.com/v1/beacon?" + BISDetectorREST.getCommonRequestArguments();
        BISDetectorAsyncRequest urlCaller = new BISDetectorAsyncRequest();
        String responseString = null;
        try {
            urlCaller.execute(new String[]{urlToCall});
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)("IllegalStateException: " + e.getMessage()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                responseString = (String)urlCaller.get();
            }
            catch (InterruptedException e) {
                Log.e((String)TAG, (String)("InterruptedException: " + e.getMessage()));
            }
            catch (ExecutionException e) {
                Log.e((String)TAG, (String)("ExecutionException: " + e.getMessage()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return responseString;
    }

    public static String notifyAboutBeaconEnter(Beacon beacon) {
        return BISDetectorREST.sendBeaconEvent(beacon, true);
    }

    public static String notifyAboutBeaconExit(Beacon beacon) {
        return BISDetectorREST.sendBeaconEvent(beacon, false);
    }

    private static String getCommonRequestArguments() {
        String os = "";
        String device = "";
        String brand = "";
        String model = "";
        String manufacturer = "";
        String userAgent = "";
        String tz = "";
        String language = "";
        String country = "";
        String sdkVersion = "";
        try {
            os = "ANDROID" + URLEncoder.encode(" " + Build.VERSION.RELEASE, "UTF-8");
            device = URLEncoder.encode(Build.DEVICE, "UTF-8");
            brand = URLEncoder.encode(Build.BRAND, "UTF-8");
            model = URLEncoder.encode(Build.MODEL, "UTF-8");
            tz = URLEncoder.encode(TimeZone.getDefault().getID(), "UTF-8");
            language = URLEncoder.encode(Locale.getDefault().toString(), "UTF-8");
            country = URLEncoder.encode(Locale.getDefault().toString(), "UTF-8");
            userAgent = URLEncoder.encode(System.getProperty("http.agent"), "UTF-8");
            sdkVersion = URLEncoder.encode(BISDetector.SDK_VERSION, "UTF-8");
            manufacturer = URLEncoder.encode(Build.MANUFACTURER, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)("UnsupportedEncodingException: " + e.getMessage()));
        }
        double dateCreated = (double)System.currentTimeMillis() / 1000.0;
        return String.format("userId=%s&userIdType=%s&userId2=%s&userIdType2=%s&os=%s&device=%s&brand=%s&model=%s&manufacturer=%s&userAgent=%s&tz=%s&language=%s&country=%s&sdkVersion=%s&createdAt=%f", BISDetector.UUID.toString() != null ? BISDetector.UUID.toString() : "", "AUUID", BISDetector.ADID != null ? BISDetector.ADID : "", "ADID", os, device, brand, model, manufacturer, userAgent, tz, language, country, sdkVersion, dateCreated);
    }

    private static String getLocationRequestArguments(Location location) {
        String s = "";
        if (location != null) {
            String latitude = Double.toString(location.getLatitude());
            String longitude = Double.toString(location.getLongitude());
            String horizationAccuracy = Float.toString(location.getAccuracy());
            String altitude = Double.toString(location.getAltitude());
            String speed = Float.toString(location.getSpeed());
            String bearing = Float.toString(location.getBearing());
            s = s + "&gpsLatitude=" + latitude + "&gpsLongitude=" + longitude + "&gpsHorizontalAccuracy=" + horizationAccuracy + "&gpsAltitude=" + altitude + "&gpsSpeed=" + speed + "&gpsBearing=" + bearing;
        }
        return s;
    }

    private static String sendBeaconEvent(Beacon beacon, boolean isEnter) {
        String[] beaconIds = BISDetectorManager.idsForBeacon(beacon);
        String beaconId = BISDetectorManager.uniqueIdentifierForBeacon(beacon);
        if (beaconIds == null || beaconIds.length < 3) {
            return null;
        }
        Location location = BISLocationListener.getLocationByBeaconId(beaconId);
        String locationArguments = BISDetectorREST.getLocationRequestArguments(location);
        String customDataString = String.format("uuid=%s&major=%s&minor=%s&detect=%s", beaconIds[0], beaconIds[1], beaconIds[2], isEnter ? "enter" : "exit");
        String commonDataString = BISDetectorREST.getCommonRequestArguments();
        String dataString = customDataString + "&" + commonDataString;
        if (!locationArguments.equals("")) {
            dataString = dataString + "&" + locationArguments;
        }
        HashMap<String, String> beaconData = BISDetectorManager.collectBeaconInfo(beacon);
        for (String key : beaconData.keySet()) {
            String value = beaconData.get(key);
            if (value == null) continue;
            try {
                String encodedKey = URLEncoder.encode(key, "UTF-8");
                String encodedValue = URLEncoder.encode(value, "UTF-8");
                dataString = dataString + "&" + encodedKey + "=" + encodedValue;
            }
            catch (UnsupportedEncodingException encodedKey) {}
        }
        if (!isEnter) {
            try {
                String rssiJson = BISDetectorManager.getBeaconRssiJson(beacon);
                Integer gpsRssi = BISDetectorManager.getBeaconGPSRssi(beacon);
                String gpsRssiString = "";
                if (gpsRssi != null) {
                    gpsRssiString = gpsRssi.toString();
                }
                dataString = dataString + "&rssi=" + URLEncoder.encode(rssiJson, "UTF-8");
                dataString = dataString + "&gpsRssi=" + URLEncoder.encode(gpsRssiString, "UTF-8");
            }
            catch (UnsupportedEncodingException rssiJson) {
                // empty catch block
            }
        }
        if (!BISPersistentStorage.isdeviceMetaDataSent()) {
            String deviceMetaDataEncoded = BISDetectorREST.getDeviceMetaData();
            dataString = dataString + "&deviceMetaData=" + deviceMetaDataEncoded;
            BISPersistentStorage.setDeviceMetaDataSent(true);
        }
        final String finalDataString = dataString;
        final String[] resultStringData = new String[1];
        Thread thread = new Thread(){

            @Override
            public void run() {
                resultStringData[0] = BISDetectorREST.sendData(finalDataString);
            }
        };
        try {
            thread.start();
            thread.join();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("sendBeaconEvent thread error:" + e.getMessage()));
        }
        return resultStringData[0];
    }

    static String getAuthorizationHeader() {
        String USER_KEY = BISDetector.API_KEY;
        String PACKAGE_NAME = BISDetector.getContext() != null ? BISDetector.getContext().getPackageName() : "";
        String authString = USER_KEY + ":" + PACKAGE_NAME;
        byte[] authBytes = authString.getBytes();
        String base64AuthString = Base64.encodeToString((byte[])authBytes, (int)0, (int)authString.length(), (int)2);
        String authorizationHeader = "Basic " + base64AuthString;
        return authorizationHeader;
    }

    private static String getDeviceMetaData() {
        String deviceMetaData = BISPersistentStorage.getDeviceMetaDataString();
        String deviceMetaDataEncoded = "";
        try {
            deviceMetaDataEncoded = URLEncoder.encode(deviceMetaData, "UTF-8");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Failed to encode deviceMetaData string: " + e.getMessage()));
        }
        return deviceMetaDataEncoded;
    }

    static String sendGPSEvent(Location location, boolean sendAdditionalData) {
        if (location == null) {
            return null;
        }
        String customDataString = String.format("detect=%s", "gps");
        String commonDataString = BISDetectorREST.getCommonRequestArguments();
        String locationArguments = BISDetectorREST.getLocationRequestArguments(location);
        String dataString = customDataString + "&" + commonDataString;
        if (!locationArguments.equals("")) {
            dataString = dataString + "&" + locationArguments;
        }
        if (!BISPersistentStorage.isdeviceMetaDataSent()) {
            String deviceMetaDataEncoded = BISDetectorREST.getDeviceMetaData();
            dataString = dataString + "&deviceMetaData=" + deviceMetaDataEncoded;
            BISPersistentStorage.setDeviceMetaDataSent(true);
        }
        final String finalDataString = dataString;
        final String[] resultStringData = new String[1];
        Thread thread = new Thread(){

            @Override
            public void run() {
                resultStringData[0] = BISDetectorREST.sendData(finalDataString);
            }
        };
        try {
            thread.start();
            thread.join();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("sendBeaconEvent thread error: " + e.getMessage()));
        }
        return resultStringData[0];
    }

    static String collectInstalledPackages() {
        String appString = "";
        try {
            PackageManager pm = BISDetector.sharedInstance.getPackageManager();
            List applications = pm.getInstalledApplications(128);
            boolean isFirst = true;
            for (ApplicationInfo appInfo : applications) {
                if (appInfo.sourceDir.toLowerCase().startsWith("/system")) continue;
                if (!isFirst) {
                    appString = appString + "|";
                } else {
                    isFirst = false;
                }
                appString = appString + appInfo.packageName;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return appString;
    }

    static String sendData(String data) {
        if (data == null) {
            return null;
        }
        String url = BIS_URL_EVENT;
        String result = null;
        String authorizationHeader = BISDetectorREST.getAuthorizationHeader();
        try {
            String line;
            HttpURLConnection urlConnection = (HttpURLConnection)new URL(url).openConnection();
            urlConnection.setDoOutput(true);
            urlConnection.setRequestProperty("Authorization", authorizationHeader);
            urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            urlConnection.setRequestProperty("Accept", "application/json");
            urlConnection.setRequestMethod("POST");
            urlConnection.connect();
            OutputStream outputStream = urlConnection.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            writer.write(data);
            writer.close();
            outputStream.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "UTF-8"));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            reader.close();
            result = sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)("UnsupportedEncodingException: " + e.getMessage()));
            return null;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("IOException: " + e.getMessage()));
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HashMap<String, String> getInitializationData() {
        HashMap<String, String> data = new HashMap<String, String>();
        BISDetectorAsyncRequest urlCaller = new BISDetectorAsyncRequest();
        String responseString = null;
        try {
            urlCaller.execute(new String[]{BIS_URL_INITIALIZE});
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)("IllegalStateException: " + e.getMessage()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                responseString = (String)urlCaller.get();
            }
            catch (InterruptedException e) {
                Log.e((String)TAG, (String)("InterruptedException: " + e.getMessage()));
            }
            catch (ExecutionException e) {
                Log.e((String)TAG, (String)("ExecutionException: " + e.getMessage()));
            }
        }
        if (responseString == null) {
            return null;
        }
        try {
            JSONObject jsonObject = new JSONObject(responseString);
            int responseCode = jsonObject.getInt("code");
            if (responseCode != 200) {
                BISDetector.sharedInstance.onBeaconsInfoReceiveFail(responseCode, null);
                return null;
            }
            JSONObject jsonObjectData = jsonObject.getJSONObject("data");
            Iterator keyIterator = jsonObjectData.keys();
            while (keyIterator.hasNext()) {
                String key = (String)keyIterator.next();
                String value = jsonObjectData.getString(key);
                data.put(key, value);
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("JSONException: " + e.getMessage()));
            BISDetector.sharedInstance.onBeaconsInfoReceiveFail(503, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }
}

