/*
 * Copyright (c) 2008-2016 Afilias Technologies Limited. All rights reserved.
 */
package com.beaconsinspace.android.beacon.detector.DeviceAtlas;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.webkit.WebSettings;
import android.webkit.WebView;

import org.json.JSONException;
import org.json.JSONObject;

import java.lang.reflect.Constructor;
import java.util.TreeMap;

/**
 * @author Afilias Technologies Ltd
 */
class WebProperties {
    private static final String SYSTEM_USER_AGENT = "systemUserAgent";
    private static final String WEBVIEW_USER_AGENT = "webviewUserAgent";



    public static JSONObject getProperties(Context context) throws JSONException {
        JSONObject props = new JSONObject();
        props.put(SYSTEM_USER_AGENT, System.getProperty("http.agent"));
        props.put(WEBVIEW_USER_AGENT, getWebviewUserAgentString(context));

        return props;
    }


    private static String getWebviewUserAgentString(Context context) {
        if (Build.VERSION.SDK_INT >= 17) {
            return NewApiWrapper.getDefaultUserAgent(context);
        }


        try {
            Constructor<WebSettings> constructor = WebSettings.class.getDeclaredConstructor(Context.class, WebView.class);
            constructor.setAccessible(true);
            try {
                WebSettings settings = constructor.newInstance(context, null);
                return settings.getUserAgentString();
            } finally {
                constructor.setAccessible(false);
            }
        } catch (Exception e) {
            WebView webView = new WebView(context);
            // todo: run local socket listener and capture HTTP headers.

            return webView.getSettings().getUserAgentString();
        }
    }


    @TargetApi(17)
    static class NewApiWrapper {
        static String getDefaultUserAgent(Context context) {
            return WebSettings.getDefaultUserAgent(context);
        }
    }


}
