/*
 * Copyright (c) 2008-2016 Afilias Technologies Limited. All rights reserved.
 */

package com.beaconsinspace.android.beacon.detector.DeviceAtlas;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.os.Build;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

/**
 * @author Afilias Technologies Ltd
 */
public class SensorProperties {

    public static JSONArray getProperties(Context context) throws JSONException {
        JSONArray props = new JSONArray();

        SensorManager mgr = (SensorManager) context.getSystemService(context.SENSOR_SERVICE);
        List<Sensor> sensors = mgr.getSensorList(Sensor.TYPE_ALL);
        for (Sensor sensor : sensors) {
            JSONObject s = new JSONObject();

            s.put("name", sensor.getName());
            s.put("vendor", sensor.getVendor());
            s.put("maxRange", sensor.getMaximumRange());
            s.put("powerMa", sensor.getPower()); // mA
            s.put("resolution", sensor.getResolution());
            s.put("version", sensor.getVersion());

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.GINGERBREAD) {
                s.put("minDelayUs", sensor.getMinDelay()); // API >= 9
            }

            String type;
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT_WATCH) {
                type = cleanType(sensor.getStringType()); // API >= 20
            } else {
                type = getTypeFromId(sensor.getType());
            }
            s.put("type", type);

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                s.put("isWakeUpSensor", sensor.isWakeUpSensor()); // API >=21
                s.put("maxDelayUs", sensor.getMaxDelay());
                s.put("reportingMode", getReportingMode(sensor.getReportingMode()));
            }

            props.put(s);
        }

        return props;
    }


    private static String getReportingMode(int mode) {

        switch(mode) {
            case Sensor.REPORTING_MODE_CONTINUOUS:
                return "continuous";
            case Sensor.REPORTING_MODE_ON_CHANGE:
                return "on_change";
            case Sensor.REPORTING_MODE_ONE_SHOT:
                return "one_shot";
            case Sensor.REPORTING_MODE_SPECIAL_TRIGGER:
                return "SPECIAL_TRIGGER";
            default:
                return "id="+mode;
        }
    }


    private static String cleanType(String type) {
        String prefix = "android.sensor.";
        if(type.startsWith(prefix)) {
           type = type.substring(prefix.length());
        }
        return type;
    }

    private static String getTypeFromId(int type) {

        switch(type) {
            case Sensor.TYPE_ACCELEROMETER:
                return "accelerometer";
            case Sensor.TYPE_MAGNETIC_FIELD:
                return "magnetic_field";
            case Sensor.TYPE_ORIENTATION:
                return "orientation";
            case Sensor.TYPE_GYROSCOPE:
                return "gyroscope";
            case Sensor.TYPE_LIGHT:
                return "light";
            case Sensor.TYPE_PRESSURE:
                return "pressure";
            case Sensor.TYPE_TEMPERATURE:
                return "temperature";
            case Sensor.TYPE_PROXIMITY:
                return "proximity";
            case Sensor.TYPE_GRAVITY:
                return "gravity";
            case Sensor.TYPE_LINEAR_ACCELERATION:
                return "linear_acceleration";
            case Sensor.TYPE_ROTATION_VECTOR:
                return "rotation_vector";
            case Sensor.TYPE_RELATIVE_HUMIDITY:
                return "relative_humidity";
            case Sensor.TYPE_AMBIENT_TEMPERATURE:
                return "ambient_temperature";
            case Sensor.TYPE_MAGNETIC_FIELD_UNCALIBRATED:
                return "magnetic_field_uncalibrated";
            case Sensor.TYPE_GAME_ROTATION_VECTOR:
                return "game_rotation_vector";
            case Sensor.TYPE_GYROSCOPE_UNCALIBRATED:
                return "gyroscope_uncalibrated";
            case Sensor.TYPE_SIGNIFICANT_MOTION:
                return "significant_motion";
            case Sensor.TYPE_STEP_DETECTOR:
                return "step_detector";
            case Sensor.TYPE_STEP_COUNTER:
                return "step_counter";
            case Sensor.TYPE_GEOMAGNETIC_ROTATION_VECTOR:
                return "geomagnetic_rotation_vector";
            case Sensor.TYPE_HEART_RATE:
                return "heart_rate";
            default:
                return "id="+type;
        }
    }

}
