/*
 * Copyright (c) 2008-2016 Afilias Technologies Limited. All rights reserved.
 */

package com.beaconsinspace.android.beacon.detector.DeviceAtlas;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

/**
 * @author Afilias Technologies Ltd
 */
class MemoryProperties {

    private static final String MEM_INFO_PATH = "/proc/meminfo";
    private static final String MEM_TOTAL = "memTotal";



    public static JSONObject getProperties() throws JSONException {
        JSONObject props = new JSONObject();

        List<String> lines = FileUtil.loadLines(MEM_INFO_PATH);

        for(String line : lines) {
            String[] keyVal = line.split(":", 2);
            if(keyVal.length == 2) {
                String key = keyVal[0].trim();
                if(key.toLowerCase().equals(MEM_TOTAL.toLowerCase())) {
                    props.put(MEM_TOTAL, keyVal[1].trim());
                    break;
                }
            }
        }

        return props;
    }
}
