/*
 * Copyright (c) 2008-2016 Afilias Technologies Limited. All rights reserved.
 */

package com.beaconsinspace.android.beacon.detector.DeviceAtlas;

import android.app.Activity;
import android.opengl.GLSurfaceView;
import android.view.ViewGroup;

import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

/**
 * @author Afilias Technologies Ltd
 */
class GpuRenderer implements GLSurfaceView.Renderer {

    private Activity activityContext;
    private GLSurfaceView glSurfaceView;
    private DataCollector callback;

    protected GpuRenderer(Activity activityContext, GLSurfaceView glSurfaceView, DataCollector callback) {
        this.activityContext = activityContext;
        this.glSurfaceView = glSurfaceView;
        this.callback = callback;
    }

    @Override
    public void onSurfaceCreated(GL10 gl, EGLConfig eglConfig) {
        final GpuProperties props = new GpuProperties(gl);

        activityContext.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                // remove the surface view as we're done with it and notify the callback.
                ViewGroup layout = (ViewGroup) activityContext.findViewById(android.R.id.content); // android.R.id.content gives the root view for a context
                layout.removeView(glSurfaceView);

                callback.collectStats(props);
            }
        });
    }

    @Override
    public void onSurfaceChanged(GL10 gl10, int width, int height) {
        // not needed
    }

    @Override
    public void onDrawFrame(GL10 gl) {
        // not needed
    }


}
