/*
 * Copyright (c) 2008-2016 Afilias Technologies Limited. All rights reserved.
 */

package com.beaconsinspace.android.beacon.detector.DeviceAtlas;

import android.os.AsyncTask;
import android.util.Log;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;


/**
 * @author Afilias Technologies Ltd
 */
public class DataCourier extends AsyncTask<URL, String, Long> {
    private DataCourierCallback callback;
    private String data = null;
    private String authUser = null;
    private String authPassword = null;

    public DataCourier() {}

    public DataCourier(DataCourierCallback callback) {
        this.callback = callback;
    }

    public void setData(String data){
        this.data = data;
    }

    public void setAuthentication(String user, String password){
        this.authUser = user;
        this.authPassword = password;
    }

    protected Long doInBackground(URL ... urls) {
        if (data == null) {
            publishProgress("Data to send is null.");
            return 0L;
        }

        publishProgress("Sending data to: " + urls.length + " URLs");
        Long ret = 0L;
        for (URL dataUrl : urls) {
            publishProgress("POST "+dataUrl.toString());

            HttpURLConnection conn = null;
            OutputStream os = null;

            try {
                // Authentication
                if (authUser != null && authPassword != null) {
                    Authenticator.setDefault(new Authenticator() {
                        @Override
                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(authUser, authPassword.toCharArray());
                        }
                    });
                }

                conn = (HttpURLConnection)dataUrl.openConnection();
                if (conn != null) {
                    conn.setDoOutput(true); // makes it do a POST request
                    conn.setRequestProperty("Content-Type", "application/json");
                    os = conn.getOutputStream();
                    os.write(data.getBytes("UTF-8"));
                    ret += data.getBytes().length;
                }
                os.close();

                publishProgress(data.getBytes().length + " bytes sent");
                publishProgress("HTTP response code: " + conn.getResponseCode());

                conn.disconnect();
            } catch (IOException ex) {
                publishProgress("Could not send data: " + ex.getMessage());
                Log.e("Could not send data", ex.getMessage());
            } finally {
                try {
                    if (os != null) {
                        os.close();
                    }

                    if(conn != null) {
                        conn.disconnect();
                    }
                } catch (IOException ex) {}
            }
        }

        return ret;
    }

    @Override
    protected void onProgressUpdate(String... progress) {
        if(callback != null) {
            for (String str : progress) {
                callback.statusUpdate(str);
            }
        }
    }



    @Override
    protected void onPostExecute(Long result) {
        if(callback != null) {
            callback.taskComplete();
        }
    }
}
