package com.beaconsinspace.android.beacon.detector;

import android.app.Activity;

import com.beaconsinspace.android.beacon.detector.DeviceAtlas.DataCollector;
import com.beaconsinspace.android.beacon.detector.DeviceAtlas.HandleDataCallback;

import org.json.JSONObject;

/**
 * Created by Akshayraj on 2/9/17.
 */

public class BISDeviceAtlas extends Activity {

    private static final String TAG = "BISDeviceAtlas";

    @Override
    protected void onStart() {
        super.onStart();
        DataCollector collector = new DataCollector(this, new HandleDataCallback() {
            @Override
            public void handleData(JSONObject data) {
                String deviceMetaData = data.toString();
                if(deviceMetaData != null || deviceMetaData != "" || deviceMetaData !="null") {
                    BISPersistentStorage.storeDeviceMetaData(deviceMetaData);
                    BISPersistentStorage.setDeviceMetaDataCollected(true);
                }
                //finish the Activity
                finish();
            }
        });
    }
}
