/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import com.beaconsinspace.android.beacon.detector.BISDetector;
import com.beaconsinspace.android.beacon.detector.BISDetectorManager;
import java.util.HashMap;
import java.util.Map;

class BISLocationListener
extends AsyncTask<String, String, Location>
implements LocationListener {
    private static final String TAG = "BIS_LOCATION_LISTENER";
    private static final int LOCATION_HALF_LIFE = 20000;
    private static final int NETWORK_PROVIDER_LOWER_ACCURACY_BOUND = 8;
    private static final int GPS_PROVIDER_LOWER_ACCURACY_BOUND = 8;
    private static final int GPS_PROVIDER_UPPER_ACCURACY_BOUND = 12;
    private static final long MAX_MONITORING_PERIOD = 15000L;
    private static final HashMap<String, Location> beaconLocations = new HashMap();
    private static boolean isCurrentlyMonitoring = false;
    private static Location currentBestLocation;
    private static boolean isMonitoringSatelliteGPS;
    private static boolean isMonitoringNetworkGPS;
    private Context context;
    private LocationManager locationManager;

    BISLocationListener(Context ctx) {
        this.context = ctx;
    }

    public static void assignLocationToBeaconId(String beaconId) {
        if (BISLocationListener.locationIsStillValid(currentBestLocation)) {
            BISLocationListener.setBeaconIdLocation(beaconId, currentBestLocation);
        } else {
            BISLocationListener.setBeaconIdLocation(beaconId, null);
            if (!isCurrentlyMonitoring) {
                currentBestLocation = null;
                BISLocationListener locationListener = new BISLocationListener(BISDetector.context);
                locationListener.execute(new String[]{beaconId});
            }
        }
    }

    public static Location getLocationByBeaconId(String beaconId) {
        Location location = beaconLocations.get(beaconId);
        beaconLocations.remove(beaconId);
        if (location == null && currentBestLocation != null) {
            location = currentBestLocation;
        }
        return location;
    }

    private static void setBeaconIdLocation(String beaconId, Location location) {
        beaconLocations.put(beaconId, location);
    }

    protected Location doInBackground(String ... beaconIdArr) {
        this.beginLocationMonitoring();
        while (isCurrentlyMonitoring) {
        }
        if (currentBestLocation != null) {
            String string = currentBestLocation.toString();
        }
        return currentBestLocation;
    }

    protected void onPostExecute(Location location) {
        try {
            for (Map.Entry<String, Location> entry : beaconLocations.entrySet()) {
                String entryBeaconId = entry.getKey();
                Location entryLocation = entry.getValue();
                if (entryLocation != null) continue;
                BISLocationListener.setBeaconIdLocation(entryBeaconId, location);
            }
            super.onPostExecute((Object)location);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("ERROR " + e.getMessage()));
        }
    }

    static boolean locationIsStillValid(Location loc) {
        if (loc == null) {
            return false;
        }
        long locTime = loc.getTime();
        long currentTime = System.currentTimeMillis();
        return currentTime - locTime < 20000L;
    }

    void beginLocationMonitoring() {
        try {
            this.locationManager = (LocationManager)this.context.getSystemService("location");
            boolean satelliteGPSAvailable = false;
            boolean networkGPSAvailable = false;
            try {
                satelliteGPSAvailable = this.locationManager.isProviderEnabled("gps");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                networkGPSAvailable = this.locationManager.isProviderEnabled("network");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!satelliteGPSAvailable && !networkGPSAvailable) {
                this.endLocationMonitoring();
                return;
            }
            isCurrentlyMonitoring = true;
            if (satelliteGPSAvailable) {
                this.beginSatelliteGPSMonitoring();
            } else {
                this.beginNetworkGPSMonitoring();
            }
            this.monitorLocationUpdates();
        }
        catch (SecurityException e) {
            Log.e((String)TAG, (String)("LOCATION EXCEPTION" + e.getMessage()));
            this.endLocationMonitoring();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("EXCEPTION " + e.getMessage()));
        }
    }

    void beginSatelliteGPSMonitoring() {
        try {
            this.locationManager.requestLocationUpdates("gps", 0L, 0.0f, (LocationListener)this, Looper.getMainLooper());
            isMonitoringSatelliteGPS = true;
        }
        catch (SecurityException e) {
            Log.e((String)TAG, (String)("Failed to monitor satellite GPS: " + e.getMessage()));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("EXCEPTION " + e.getMessage()));
        }
    }

    void beginNetworkGPSMonitoring() {
        try {
            this.locationManager.requestLocationUpdates("network", 0L, 0.0f, (LocationListener)this, Looper.getMainLooper());
            isMonitoringNetworkGPS = true;
        }
        catch (SecurityException e) {
            Log.e((String)TAG, (String)("Failed to monitor network GPS: " + e.getMessage()));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("EXCEPTION " + e.getMessage()));
        }
    }

    void monitorLocationUpdates() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (isCurrentlyMonitoring) {
            if (!isMonitoringNetworkGPS && (currentBestLocation == null || currentBestLocation.getAccuracy() >= 12.0f)) {
                this.beginNetworkGPSMonitoring();
                this.monitorLocationUpdates();
            } else {
                this.endLocationMonitoring();
            }
        }
    }

    void endLocationMonitoring() {
        try {
            this.locationManager.removeUpdates((LocationListener)this);
            isMonitoringNetworkGPS = false;
            isMonitoringSatelliteGPS = false;
            isCurrentlyMonitoring = false;
        }
        catch (SecurityException e) {
            Log.e((String)TAG, (String)("FAILED TO END LOCATION MONITORING" + e.getMessage()));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("EXCEPTION " + e.getMessage()));
        }
    }

    public void onLocationChanged(Location loc) {
        this.makeUseOfNewLocation(loc);
    }

    void makeUseOfNewLocation(Location location) {
        if (this.isBetterLocation(location, currentBestLocation)) {
            currentBestLocation = location;
            for (Map.Entry<String, Location> entry : beaconLocations.entrySet()) {
                String entryBeaconId = entry.getKey();
                Location entryLocation = entry.getValue();
                if (entryLocation != null) continue;
                BISDetectorManager.setBeaconGPSRssi(entryBeaconId);
            }
            if (location.getProvider().equals("gps") && location.getAccuracy() <= 8.0f || location.getProvider().equals("network") && location.getAccuracy() <= 8.0f) {
                this.endLocationMonitoring();
            }
        }
    }

    protected boolean isBetterLocation(Location location, Location currentBestLocation) {
        boolean isMoreAccurate;
        boolean isNewer;
        if (currentBestLocation == null) {
            return true;
        }
        long timeDelta = location.getTime() - currentBestLocation.getTime();
        boolean isSignificantlyNewer = timeDelta > 20000L;
        boolean isSignificantlyOlder = timeDelta < -20000L;
        boolean bl = isNewer = timeDelta > 0L;
        if (isSignificantlyOlder) {
            return false;
        }
        int accuracyDelta = (int)(location.getAccuracy() - currentBestLocation.getAccuracy());
        boolean isLessAccurate = accuracyDelta > 0;
        boolean bl2 = isMoreAccurate = accuracyDelta < 0;
        if (isMoreAccurate) {
            return true;
        }
        return isNewer && !isLessAccurate;
    }

    public void onStatusChanged(String var1, int var2, Bundle var3) {
    }

    public void onProviderEnabled(String var1) {
        this.beginLocationMonitoring();
    }

    public void onProviderDisabled(String var1) {
        this.endLocationMonitoring();
    }

    static {
        isMonitoringSatelliteGPS = false;
        isMonitoringNetworkGPS = false;
    }
}

