package com.beaconsinspace.android.beacon.detector;

import android.content.SharedPreferences;

import static android.content.Context.MODE_PRIVATE;

/**
 * Created by johnlfoleyiii on 12/13/16.
 */

class BISPersistentStorage
{

    static private final String sharedPreferencesFile="BIS_PERSISTENT_STORAGE";
    static private SharedPreferences sharedPreferences;
    static final String KEY_APIKEY="BIS_API_KEY";

    private static SharedPreferences getSharedPreferences()
    {
        if ( sharedPreferences == null ) { sharedPreferences = BISDetector.context.getSharedPreferences( sharedPreferencesFile, MODE_PRIVATE ); }
        return sharedPreferences;
    }

    static void storeString( String key, String value )
    {
        SharedPreferences sharedPreferences = getSharedPreferences();
        SharedPreferences.Editor sharedPreferencesEditor = sharedPreferences.edit();
        sharedPreferencesEditor.putString( key, value );
        sharedPreferencesEditor.commit(); // we want to commit and not apply so the value exists in storage immediately
    }

    static String getString( String key )
    {
        SharedPreferences sharedPreferences = getSharedPreferences();
        return sharedPreferences.getString( key, null );
    }

}
