package com.beaconsinspace.android.beacon.detector;

import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

public class BISDetectorServicesListener extends BroadcastReceiver {

    static private final String TAG = "BIS_LISTENER";

    static BISDetectorInternalDelegate delegate;

    static public void setDelegate(BISDetectorInternalDelegate _delegate) {
        delegate = _delegate;
    }

    @Override
    public void onReceive(final Context context, final Intent intent) {

        if(delegate == null) // nothing to do here
            return;

        String action = intent.getAction();

        Log.e(TAG, "Intent action: " + action);

        // ensure we have UUIDs
        delegate.checkIfShouldUpdateBeaconsInfo();

        // Bluetooth state change
        if (action.equals(BluetoothAdapter.ACTION_STATE_CHANGED)) {

            final int state = intent.getIntExtra(BluetoothAdapter.EXTRA_STATE, BluetoothAdapter.ERROR);

            switch (state) {
                case BluetoothAdapter.STATE_OFF:
                    BISDetector.stopRanging();
                    break;
                case BluetoothAdapter.STATE_TURNING_OFF:
                    break;
                case BluetoothAdapter.STATE_ON:
                    BISDetector.startRanging();
                    break;
                case BluetoothAdapter.STATE_TURNING_ON:
                    break;
                default:
                    break;
            }
        }

        // Location state change
        else if (intent.getAction().matches("android.location.PROVIDERS_CHANGED")) {
            if(BISDetector.isLocationServiceEnabled())
                BISDetector.startRanging();
            else
                BISDetector.stopRanging();
        }
    }
}
