/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.bluetooth.BluetoothAdapter;
import android.content.ContentResolver;
import android.content.Context;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.provider.Settings;
import android.util.Log;
import com.beaconsinspace.android.beacon.detector.BISDetectorDelegate;
import com.beaconsinspace.android.beacon.detector.BISDetectorInternalDelegate;
import com.beaconsinspace.android.beacon.detector.BISDetectorManager;
import com.beaconsinspace.android.beacon.detector.BISDetectorREST;
import com.beaconsinspace.android.beacon.detector.BISDetectorServicesListener;
import com.beaconsinspace.android.beacon.detector.BISDeviceUUIDFactory;
import java.util.UUID;

public class BISDetector
implements BISDetectorInternalDelegate {
    public static String SDK_VERSION = "1.2.2";
    private static final String TAG = "BIS_API";
    static String API_KEY = "";
    static String ADID = "";
    static UUID UUID;
    static BISDetector sharedInstance;
    static Context context;
    static BISDetectorManager beaconsManager;
    static BISDetectorDelegate delegate;

    public static void configure(String key, Context ctx, BISDetectorDelegate dlgt) {
        Log.d((String)TAG, (String)("Configuring BISDetector SDK " + SDK_VERSION));
        if (!BISDetector.isSafeToBootstrap()) {
            Log.d((String)TAG, (String)"This device is not supported. BeaconsInSpace Detector shutting down");
            return;
        }
        delegate = dlgt;
        API_KEY = key != null ? key : "";
        context = ctx;
        beaconsManager.setContextAndInit(ctx);
        BISDetector internalDelegate = sharedInstance;
        BISDetectorREST.setDelegate(internalDelegate);
        BISDetectorServicesListener.setDelegate(internalDelegate);
        BISDetectorManager.setDelegate(internalDelegate);
        BISDeviceUUIDFactory UUIDFactory = new BISDeviceUUIDFactory(context);
        UUID = UUIDFactory.getDeviceUuid();
        BISDetector.getUserADID();
    }

    private static boolean isSafeToBootstrap() {
        if (Build.VERSION.SDK_INT < 18) {
            Log.e((String)TAG, (String)("BeaconsInSpace Detector Library does not run on Android: " + Build.VERSION.SDK_INT));
            return false;
        }
        String[] unsupportedDeviceModels = new String[]{"Nexus 4", "Nexus 7", "XT1028", "XT1031", "XT937C", "XT1002", "XT1003", "XT1008", "XT1032", "XT1034", "XT939G", "XT1033", "XT1069", "titan_retbr_dstv", "XT1063", "XT1064", "XT1068", "titan_niibr_ds", "MotoG3", "Moto G (4)", "XT1032", "MotoG3", "TE", "XT1039", "XT1040", "XT1042", "XT1045", "XT1072", "XT1077", "XT1079", "XT1063", "XT1078", "XT1225", "XT1225", "XT1049", "XT1050", "XT1052", "XT1053", "XT1055", "XT1056", "XT1058", "XT1060", "XT1085", "XT1092", "XT1093", "XT1094", "XT1095", "XT1096", "XT1097", "XT1098", "XT1580", "XT1580", "XT1581", "XT1021", "XT1562", "XT1563", "XT1564", "XT1021", "XT1562", "XT1563", "XT1575", "XT1572", "XT1570", "XT1572"};
        String deviceModel = Build.MODEL;
        for (String unsupportedModel : unsupportedDeviceModels) {
            if (!deviceModel.equals(unsupportedModel)) continue;
            return false;
        }
        return true;
    }

    public static void setBeaconManagerScanPeriods(Long foregroundScanPeriod, Long foregroundBetweenScanPeriod, Long backgroundScanPeriod, Long backgroundBetweenScanPeriod) {
        beaconsManager.setScanPeriods(foregroundScanPeriod, foregroundBetweenScanPeriod, backgroundScanPeriod, backgroundBetweenScanPeriod);
    }

    static void performInitialSetup() {
        String errorMessage = "";
        if (!BISDetector.isLocationServiceEnabled()) {
            errorMessage = "Location Services are not enabled. Please enable them in Settings.";
            Log.e((String)TAG, (String)errorMessage);
            if (delegate != null) {
                delegate.onBISError(409, errorMessage);
            }
            return;
        }
        if (!BISDetector.isInternetAvailable()) {
            errorMessage = "Network Services are not enabled. Please enable them in Settings.";
            Log.e((String)TAG, (String)errorMessage);
            if (delegate != null) {
                delegate.onBISError(409, errorMessage);
            }
            return;
        }
        if (!BISDetector.isBluetoothEnabled()) {
            errorMessage = "Bluetooth is not enabled. Please turn it on to proceed";
            Log.e((String)TAG, (String)errorMessage);
            if (delegate != null) {
                delegate.onBISError(409, errorMessage);
            }
            return;
        }
        BISDetectorREST.getBeaconsInfoFromServer();
    }

    static BISDetectorManager beaconsManager() {
        return beaconsManager;
    }

    static void getUserADID() {
        if (context == null) {
            return;
        }
        Thread thread = new Thread(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        thread.start();
    }

    public static boolean isLocationServiceEnabled() {
        if (context == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            int locationMode = 0;
            try {
                locationMode = Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"location_mode");
            }
            catch (Settings.SettingNotFoundException e) {
                Log.e((String)TAG, (String)("Failed to check for location services: " + e.getMessage()));
                return false;
            }
            return locationMode != 0;
        }
        LocationManager lm = (LocationManager)context.getSystemService("location");
        boolean gps_enabled = false;
        boolean network_enabled = false;
        try {
            gps_enabled = lm.isProviderEnabled("gps");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            network_enabled = lm.isProviderEnabled("network");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return gps_enabled || network_enabled;
    }

    public static boolean isInternetAvailable() {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    public static boolean isBluetoothEnabled() {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter == null) {
            return false;
        }
        return adapter.isEnabled();
    }

    public static void startRanging() {
        beaconsManager.setContextAndInit(context);
        beaconsManager.startRanging();
    }

    public static void stopRanging() {
        beaconsManager.stopRanging();
    }

    static void onUserADIDReceiveSuccess() {
        BISDetector.performInitialSetup();
    }

    static void onUserADIDReceiveFail() {
        BISDetector.performInitialSetup();
    }

    @Override
    public void onBeaconsInfoReceiveSuccess() {
        Log.d((String)TAG, (String)"BLE ranging has begun");
        BISDetector.startRanging();
    }

    @Override
    public void onBeaconsInfoReceiveFail(int errorCode, String errorMessage) {
        if (errorMessage == null) {
            switch (errorCode) {
                case 401: {
                    errorMessage = "Invalid Authentication";
                    break;
                }
                default: {
                    errorMessage = "An error occurred";
                }
            }
        }
        errorMessage = errorCode + " : " + errorMessage;
        Log.e((String)TAG, (String)errorMessage);
        if (delegate != null) {
            delegate.onBISError(503, errorMessage);
        }
    }

    @Override
    public void checkIfShouldUpdateBeaconsInfo() {
        if (BISDetector.isInternetAvailable() && BISDetector.beaconsManager.uuids.size() == 0) {
            BISDetectorREST.getBeaconsInfoFromServer();
        }
    }

    @Override
    public void onBeaconEnter(String beaconId) {
        if (delegate != null) {
            delegate.didEnterBISRegion(beaconId);
        }
    }

    @Override
    public void onBeaconExit(String beaconId) {
        if (delegate != null) {
            delegate.didExitBISRegion(beaconId);
        }
    }

    static {
        sharedInstance = new BISDetector();
        beaconsManager = new BISDetectorManager();
    }
}

