/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.RemoteException;
import android.util.Log;
import com.beaconsinspace.android.beacon.detector.BISDetectorInternalDelegate;
import com.beaconsinspace.android.beacon.detector.BISDetectorREST;
import com.beaconsinspace.android.beacon.detector.BISDetectorRSSICollector;
import com.beaconsinspace.android.beacon.detector.BISLocationListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconConsumer;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.BeaconParser;
import org.altbeacon.beacon.Identifier;
import org.altbeacon.beacon.RangeNotifier;
import org.altbeacon.beacon.Region;
import org.altbeacon.beacon.utils.UrlBeaconUrlCompressor;
import org.json.JSONException;
import org.json.JSONObject;

class BISDetectorManager
implements BeaconConsumer {
    private static final String TAG = "BIS_BEACONS_MANAGER";
    private static final Long BEACON_EXIT_THRESHOLD = 30000L;
    static BISDetectorInternalDelegate delegate;
    Context context = null;
    BeaconManager beaconManager = null;
    private static final ConcurrentHashMap<Beacon, Long> beaconTimestampMap;
    private static final ConcurrentHashMap<Beacon, BISDetectorRSSICollector> beaconRssiMap;
    public ArrayList<String> uuids = new ArrayList();

    BISDetectorManager() {
    }

    public static void setDelegate(BISDetectorInternalDelegate _delegate) {
        delegate = _delegate;
    }

    public boolean setContextAndInit(Context ctx) {
        if (ctx == null) {
            Log.e((String)TAG, (String)"Context is null");
            return false;
        }
        this.context = ctx;
        if (this.beaconManager == null) {
            this.beaconManager = BeaconManager.getInstanceForApplication((Context)this.context);
            this.setScanPeriods(null, null, null, 60000L);
            String iBeaconLayout = "m:2-3=0215,i:4-19,i:20-21,i:22-23,p:24-24";
            this.beaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout(iBeaconLayout));
            String altBeaconLayout = "m:2-3=beac,i:4-19,i:20-21,i:22-23,p:24-24,d:25-25";
            this.beaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout(altBeaconLayout));
            String eddystoneUIDBeaconLayout = "s:0-1=feaa,m:2-2=00,p:3-3:-41,i:4-13,i:14-19";
            this.beaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout(eddystoneUIDBeaconLayout));
            String eddystoneURLBeaconLayout = "s:0-1=feaa,m:2-2=10,p:3-3:-41,i:4-20v";
            this.beaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout(eddystoneURLBeaconLayout));
            this.doBind();
        }
        return true;
    }

    public void setScanPeriods(Long foregroundScanPeriod, Long foregroundBetweenScanPeriod, Long backgroundScanPeriod, Long backgroundBetweenScanPeriod) {
        if (this.beaconManager == null) {
            Log.i((String)TAG, (String)"Beacon Manager not initialized, not setting scan periods.");
            return;
        }
        if (foregroundScanPeriod != null) {
            this.beaconManager.setForegroundScanPeriod(foregroundScanPeriod.longValue());
        }
        if (foregroundBetweenScanPeriod != null) {
            this.beaconManager.setForegroundBetweenScanPeriod(foregroundBetweenScanPeriod.longValue());
        }
        if (backgroundScanPeriod != null) {
            this.beaconManager.setBackgroundScanPeriod(backgroundScanPeriod.longValue());
        }
        if (backgroundBetweenScanPeriod != null) {
            this.beaconManager.setBackgroundBetweenScanPeriod(backgroundBetweenScanPeriod.longValue());
        }
        try {
            if (this.beaconManager.isBound((BeaconConsumer)this)) {
                this.beaconManager.updateScanPeriods();
            }
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("Error updating scan periods: " + e.getMessage()));
        }
    }

    public void updateUUIDs(ArrayList<String> _uuids) {
        this.uuids = new ArrayList<String>(_uuids);
    }

    public void startRanging() {
        this.stopRanging();
        this.doBind();
    }

    public void stopRanging() {
        try {
            Collection regions = this.beaconManager.getRangedRegions();
            for (Region region : regions) {
                this.beaconManager.stopRangingBeaconsInRegion(region);
            }
            this.undoBind();
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("RemoteException: " + e.toString()));
        }
    }

    public void doBind() {
        if (this.beaconManager != null && !this.beaconManager.isBound((BeaconConsumer)this)) {
            this.beaconManager.bind((BeaconConsumer)this);
        }
    }

    public void undoBind() {
        if (this.beaconManager != null && this.beaconManager.isBound((BeaconConsumer)this)) {
            this.beaconManager.unbind((BeaconConsumer)this);
        }
    }

    public void onBeaconServiceConnect() {
        this.beaconManager.setRangeNotifier(new RangeNotifier(){

            public void didRangeBeaconsInRegion(Collection<Beacon> collection, Region region) {
                Long beaconLastSeenTimestamp;
                Long currentTimestamp = System.currentTimeMillis();
                for (Beacon beacon : collection) {
                    beaconLastSeenTimestamp = (Long)beaconTimestampMap.get(beacon);
                    if (beaconLastSeenTimestamp == null) {
                        Log.d((String)BISDetectorManager.TAG, (String)("ENTERED BEACON " + BISDetectorManager.uniqueIdentifierForBeacon(beacon)));
                        BISDetectorManager.this.handleBeaconEnter(beacon);
                        beaconRssiMap.put(beacon, new BISDetectorRSSICollector());
                    }
                    BISDetectorRSSICollector rssiCollector = (BISDetectorRSSICollector)beaconRssiMap.get(beacon);
                    rssiCollector.add(beacon.getRssi());
                    beaconRssiMap.put(beacon, rssiCollector);
                    beaconTimestampMap.put(beacon, currentTimestamp);
                }
                for (Beacon beacon : beaconTimestampMap.keySet()) {
                    beaconLastSeenTimestamp = (Long)beaconTimestampMap.get(beacon);
                    Long diff = currentTimestamp - beaconLastSeenTimestamp;
                    if (diff > BEACON_EXIT_THRESHOLD) {
                        Log.d((String)BISDetectorManager.TAG, (String)("EXITED BEACON " + BISDetectorManager.uniqueIdentifierForBeacon(beacon)));
                        BISDetectorManager.this.handleBeaconExit(beacon);
                        beaconTimestampMap.remove(beacon);
                        continue;
                    }
                    Log.d((String)BISDetectorManager.TAG, (String)("BEACON " + BISDetectorManager.uniqueIdentifierForBeacon(beacon) + " TIME SINCE SEEN " + diff + " "));
                }
            }
        });
        try {
            this.beaconManager.startRangingBeaconsInRegion(new Region("ALL_BEACONS", null, null, null));
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("RemoteException: " + e.toString()));
        }
    }

    public static String getBeaconRssiJson(Beacon beacon) {
        return beaconRssiMap.get(beacon).toJson();
    }

    private Region getBeaconRegion(Beacon beacon) {
        return new Region(BISDetectorManager.uniqueIdentifierForBeacon(beacon), beacon.getId1(), null, null);
    }

    public static HashMap<String, String> collectBeaconInfo(Beacon beacon) {
        HashMap<String, String> data = new HashMap<String, String>();
        try {
            data.put("beaconId1", BISDetectorManager.beaconIdentifierToString(beacon.getId1()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            data.put("beaconId2", BISDetectorManager.beaconIdentifierToString(beacon.getId2()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            data.put("beaconId3", BISDetectorManager.beaconIdentifierToString(beacon.getId3()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        data.put("beaconServiceUUID", Integer.toString(beacon.getServiceUuid()));
        int TxPower = beacon.getTxPower();
        String TxPowerString = Integer.toString(TxPower);
        data.put("beaconTxPower", TxPowerString);
        Double distance = beacon.getDistance();
        String distanceString = Double.toString(distance);
        data.put("beaconDistance", distanceString);
        String bName = beacon.getBluetoothName();
        data.put("beaconName", bName);
        int manufacturer = beacon.getManufacturer();
        String manufacturerString = Integer.toString(manufacturer);
        data.put("beaconManufacturer", manufacturerString);
        int type = beacon.getBeaconTypeCode();
        String typeString = Integer.toString(type);
        data.put("beaconTypeCode", typeString);
        if (beacon.getServiceUuid() == 65194 && beacon.getBeaconTypeCode() == 16) {
            String url = UrlBeaconUrlCompressor.uncompress((byte[])beacon.getId1().toByteArray());
            data.put("beaconURL", url);
        }
        if (beacon.getServiceUuid() == 65194 && beacon.getBeaconTypeCode() == 0 && beacon.getExtraDataFields().size() > 0) {
            long telemetryVersion = (Long)beacon.getExtraDataFields().get(0);
            long batteryMilliVolts = (Long)beacon.getExtraDataFields().get(1);
            long pduCount = (Long)beacon.getExtraDataFields().get(3);
            long uptime = (Long)beacon.getExtraDataFields().get(4);
            data.put("beaconTelemetryVersion", Long.toString(telemetryVersion));
            data.put("beaconTelemetryBattery", Long.toString(batteryMilliVolts));
            data.put("beaconTelemetryPduCount", Long.toString(pduCount));
            data.put("beaconTelemetryUptime", Long.toString(uptime));
        }
        return data;
    }

    public static String beaconIdentifierToString(Identifier i) {
        if (i == null) {
            return null;
        }
        String s = i.toString();
        if (s == null) {
            return null;
        }
        if (s.length() >= 2 && s.substring(0, 2).equals("0x")) {
            s = s.substring(2);
        }
        return s;
    }

    private void handleBeaconEnter(Beacon b) {
        final Beacon beacon = b;
        Thread thread = new Thread(){

            @Override
            public void run() {
                String jsonDataString = BISDetectorREST.notifyAboutBeaconEnter(beacon);
                String beaconId = null;
                if (jsonDataString != null) {
                    try {
                        JSONObject jsonDataObject = new JSONObject(jsonDataString);
                        int code = jsonDataObject.getInt("code");
                        if (code != 200) {
                            Log.e((String)BISDetectorManager.TAG, (String)("Unsuccessful API Response occurred" + jsonDataString));
                            Log.e((String)BISDetectorManager.TAG, (String)beacon.toString());
                            return;
                        }
                        beaconId = jsonDataObject.getJSONObject("data").getString("beaconId");
                    }
                    catch (JSONException e) {
                        Log.e((String)BISDetectorManager.TAG, (String)("Failed to parse JSON" + e.getMessage()));
                    }
                }
                if (delegate != null && beaconId != null) {
                    BISLocationListener.assignLocationToBeaconId(BISDetectorManager.uniqueIdentifierForBeacon(beacon));
                    delegate.onBeaconEnter(beaconId);
                }
            }
        };
        thread.start();
    }

    private void handleBeaconExit(Beacon b) {
        final Beacon beacon = b;
        Thread thread = new Thread(){

            @Override
            public void run() {
                String jsonDataString = BISDetectorREST.notifyAboutBeaconExit(beacon);
                String beaconId = null;
                if (jsonDataString != null) {
                    try {
                        JSONObject jsonDataObject = new JSONObject(jsonDataString);
                        int code = jsonDataObject.getInt("code");
                        if (code != 200) {
                            Log.e((String)BISDetectorManager.TAG, (String)("Unsuccessful API Response occurred" + jsonDataString));
                            Log.e((String)BISDetectorManager.TAG, (String)beacon.toString());
                            return;
                        }
                        beaconId = jsonDataObject.getJSONObject("data").getString("beaconId");
                    }
                    catch (JSONException e) {
                        Log.e((String)BISDetectorManager.TAG, (String)("Failed to parse JSON" + e.getMessage()));
                    }
                }
                if (delegate != null && beaconId != null) {
                    delegate.onBeaconExit(beaconId);
                }
            }
        };
        thread.start();
    }

    public static String[] idsForBeacon(Beacon beacon) {
        if (beacon == null) {
            return new String[]{"", "", ""};
        }
        Identifier id1 = beacon.getIdentifiers().size() > 0 ? beacon.getId1() : null;
        Identifier id2 = beacon.getIdentifiers().size() > 1 ? beacon.getId2() : null;
        Identifier id3 = beacon.getIdentifiers().size() > 2 ? beacon.getId3() : null;
        String ID1 = id1 != null ? BISDetectorManager.beaconIdentifierToString(id1) : "";
        String ID2 = id2 != null ? BISDetectorManager.beaconIdentifierToString(id2) : "";
        String ID3 = id3 != null ? BISDetectorManager.beaconIdentifierToString(id3) : "";
        return new String[]{ID1, ID2, ID3};
    }

    public static String uniqueIdentifierForBeacon(Beacon beacon) {
        if (beacon == null) {
            return "";
        }
        String[] strings = BISDetectorManager.idsForBeacon(beacon);
        String id1 = strings[0];
        String id2 = strings[1];
        String id3 = strings[2];
        String uniqueId = id1 + "_" + id2 + "_" + id3;
        return id1 + ":" + uniqueId.hashCode();
    }

    public Context getApplicationContext() {
        return this.context;
    }

    public void unbindService(ServiceConnection serviceConnection) {
        this.context.unbindService(serviceConnection);
    }

    public boolean bindService(Intent intent, ServiceConnection serviceConnection, int i) {
        return this.context.bindService(intent, serviceConnection, i);
    }

    static {
        beaconTimestampMap = new ConcurrentHashMap();
        beaconRssiMap = new ConcurrentHashMap();
    }
}

